/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import java.util.Arrays;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.operations.ITagOperation;
import org.eclipse.team.internal.ccvs.ui.tags.TagSelectionArea;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.dialogs.DetailsDialog;

public class TagAsVersionDialog
extends DetailsDialog {
    private static final int TAG_AREA_HEIGHT_HINT = 200;
    private static final int HISTORY_LENGTH = 10;
    private static final String STORE_SECTION = "TagAsVersionDialog";
    private static final String TAG_HISTORY = "tag_history";
    private static IDialogSettings settingsSection;
    private ITagOperation operation;
    private Combo tagCombo;
    private Button moveTagButton;
    private String tagName = "";
    private boolean moveTag = false;
    private TagSource tagSource;
    private TagSelectionArea tagArea;

    public TagAsVersionDialog(Shell parentShell, String title, ITagOperation operation) {
        super(parentShell, title);
        this.tagSource = operation.getTagSource();
        this.operation = operation;
    }

    protected void createMainDialogArea(Composite parent) {
        int width = this.convertHorizontalDLUsToPixels(350);
        Label label = SWTUtils.createLabel((Composite)parent, (String)CVSUIMessages.TagAction_enterTag);
        label.setLayoutData((Object)SWTUtils.createGridData((int)width, (int)-1, (boolean)true, (boolean)false));
        this.tagCombo = this.createDropDownCombo(parent);
        this.tagName = "";
        this.tagCombo.setItems(TagAsVersionDialog.getTagNameHistory());
        this.tagCombo.setText(this.tagName);
        this.tagCombo.addModifyListener(e -> {
            this.tagName = this.tagCombo.getText();
            this.updateEnablements();
        });
        this.moveTagButton = SWTUtils.createCheckBox((Composite)parent, (String)CVSUIMessages.TagAction_moveTag);
        this.moveTagButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagAsVersionDialog.this.moveTag = TagAsVersionDialog.this.moveTagButton.getSelection();
            }
        });
    }

    protected String getHelpContextId() {
        return "org.eclipse.team.cvs.ui.tag_as_version_dialog_context";
    }

    public boolean shouldMoveTag() {
        return this.moveTag;
    }

    protected Composite createDropDownDialogArea(Composite parent) {
        PixelConverter converter = SWTUtils.createDialogPixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)SWTUtils.createGridLayout((int)1, (PixelConverter)converter, (int)1));
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        composite.setLayoutData((Object)gridData);
        this.tagArea = new TagSelectionArea(this.getShell(), this.tagSource, 8, null);
        this.tagArea.setTagAreaLabel(CVSUIMessages.TagAction_existingVersions);
        this.tagArea.setIncludeFilterInputArea(false);
        this.tagArea.createArea(composite);
        this.tagArea.addPropertyChangeListener(event -> {
            CVSTag tag2;
            if (event.getProperty().equals("selectedTag")) {
                CVSTag tag1 = this.tagArea.getSelection();
                if (tag1 != null) {
                    this.tagCombo.setText(tag1.getName());
                }
            } else if (event.getProperty().equals("openSelectedTag") && (tag2 = this.tagArea.getSelection()) != null) {
                this.tagCombo.setText(tag2.getName());
                this.okPressed();
            }
        });
        return composite;
    }

    protected void updateEnablements() {
        String message = null;
        if (this.tagName.length() == 0) {
            message = "";
        } else {
            IStatus status = CVSTag.validateTagName((String)this.tagName);
            if (!status.isOK()) {
                message = status.getMessage();
            }
        }
        this.setPageComplete(message == null);
        this.setErrorMessage(message);
        if (this.tagArea != null) {
            this.tagArea.setFilter(this.tagName);
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public ITagOperation getOperation() {
        this.operation.setTag(new CVSTag(this.tagName, 2));
        if (this.moveTag) {
            this.operation.moveTag();
        }
        return this.operation;
    }

    protected boolean isMainGrabVertical() {
        return false;
    }

    protected Combo createDropDownCombo(Composite parent) {
        Combo combo = new Combo(parent, 4);
        GridData comboData = new GridData(768);
        comboData.verticalAlignment = 2;
        comboData.grabExcessVerticalSpace = false;
        comboData.widthHint = 200;
        combo.setLayoutData((Object)comboData);
        return combo;
    }

    protected void okPressed() {
        this.rememberTagName(this.tagName);
        super.okPressed();
    }

    protected static String[] getTagNameHistory() {
        IDialogSettings section = TagAsVersionDialog.getSettingsSection();
        String[] array = section.getArray(TAG_HISTORY);
        return array != null ? array : new String[]{};
    }

    private void rememberTagName(String tagName) {
        String[] tagNameHistory = TagAsVersionDialog.getTagNameHistory();
        Vector<String> tagNames = new Vector<String>(Arrays.asList(tagNameHistory));
        if (tagNames.contains(tagName)) {
            tagNames.remove(tagName);
        }
        tagNames.add(0, tagName);
        while (tagNames.size() > 10) {
            tagNames.remove(10);
        }
        String[] array = tagNames.toArray(new String[tagNames.size()]);
        IDialogSettings section = TagAsVersionDialog.getSettingsSection();
        section.put(TAG_HISTORY, array);
    }

    private static IDialogSettings getSettingsSection() {
        if (settingsSection != null) {
            return settingsSection;
        }
        IDialogSettings settings = TeamUIPlugin.getPlugin().getDialogSettings();
        settingsSection = settings.getSection(STORE_SECTION);
        if (settingsSection != null) {
            return settingsSection;
        }
        settingsSection = settings.addNewSection(STORE_SECTION);
        return settingsSection;
    }
}

