/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.IConnectionMethod;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ExtMethodPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Text cvsRsh;
    Text cvsServer;
    Text cvsRshParameters;
    private Button useExternal;
    private Button useInternal;
    private Combo methodType;
    private Control internal;
    private Control external;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtMethodPreferencePage.this.updateEnablements();
            }
        };
        this.useExternal = this.createRadioButton(composite, CVSUIMessages.ExtMethodPreferencePage_0, 1);
        this.useExternal.addSelectionListener((SelectionListener)selectionListener);
        this.useInternal = this.createRadioButton(composite, CVSUIMessages.ExtMethodPreferencePage_1, 1);
        this.useInternal.addSelectionListener((SelectionListener)selectionListener);
        this.external = this.createExternalArea(composite);
        this.internal = this.createInternalArea(composite);
        PreferenceLinkArea proxyLink = SWTUtils.createPreferenceLink((IWorkbenchPreferenceContainer)((IWorkbenchPreferenceContainer)this.getContainer()), (Composite)composite, (String)CVSUIMessages.CVSPreferencesPage_52, (String)CVSUIMessages.CVSPreferencesPage_53);
        PreferenceLinkArea ssh2Link = SWTUtils.createPreferenceLink((IWorkbenchPreferenceContainer)((IWorkbenchPreferenceContainer)this.getContainer()), (Composite)composite, (String)CVSUIMessages.CVSPreferencesPage_54, (String)CVSUIMessages.CVSPreferencesPage_55);
        FormLayout formLayout = new FormLayout();
        composite.setLayout((Layout)formLayout);
        FormData data = new FormData();
        data.top = new FormAttachment(0, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.useExternal.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.useExternal, 5, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.external.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.external, 5, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.useInternal.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.useInternal, 5, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.internal.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.internal, 5, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        proxyLink.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(proxyLink.getControl(), 5, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        ssh2Link.getControl().setLayoutData((Object)data);
        this.initializeDefaults();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.cvs.ui.ext_preference_page_context");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void updateEnablements() {
        this.external.setEnabled(this.useExternal.getSelection());
        this.cvsRsh.setEnabled(this.useExternal.getSelection());
        this.cvsRshParameters.setEnabled(this.useExternal.getSelection());
        this.cvsServer.setEnabled(this.useExternal.getSelection());
        this.internal.setEnabled(!this.useExternal.getSelection());
        this.methodType.setEnabled(!this.useExternal.getSelection());
    }

    private Control createInternalArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label intro = new Label(composite, 16448);
        intro.setText(CVSUIMessages.ExtMethodPreferencePage_2);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        data.widthHint = 300;
        intro.setLayoutData((Object)data);
        this.createLabel(composite, CVSUIMessages.CVSPropertiesPage_connectionType, 1);
        this.methodType = this.createCombo(composite);
        return composite;
    }

    protected Control createExternalArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label intro = new Label(composite, 16448);
        intro.setText(CVSUIMessages.ExtMethodPreferencePage_message);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        data.horizontalAlignment = 4;
        data.widthHint = 300;
        intro.setLayoutData((Object)data);
        new Label(composite, 16384).setText(CVSUIMessages.ExtMethodPreferencePage_CVS_RSH);
        this.cvsRsh = new Text(composite, 2048);
        this.cvsRsh.setLayoutData((Object)new GridData(768));
        Button b = new Button(composite, 0);
        b.setText(CVSUIMessages.ExtMethodPreferencePage_Browse);
        data = new GridData();
        data.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, b.computeSize((int)-1, (int)-1, (boolean)true).x);
        b.setLayoutData((Object)data);
        b.addListener(3, event -> {
            FileDialog d = new FileDialog(this.getShell());
            d.setText(CVSUIMessages.ExtMethodPreferencePage_Details);
            String file = d.open();
            if (file != null) {
                this.setCvsRshText(file);
            }
        });
        new Label(composite, 16384).setText(CVSUIMessages.ExtMethodPreferencePage_CVS_RSH_Parameters);
        this.cvsRshParameters = new Text(composite, 2048);
        data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        this.cvsRshParameters.setLayoutData((Object)data);
        new Label(composite, 16384).setText(CVSUIMessages.ExtMethodPreferencePage_CVS_SERVER__7);
        this.cvsServer = new Text(composite, 2048);
        data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        this.cvsServer.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.cvsRsh, "org.eclipse.team.cvs.ui.ext_preference_rsh_context");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.cvsRshParameters, "org.eclipse.team.cvs.ui.ext_preference_param_context");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.cvsServer, "org.eclipse.team.cvs.ui.ext_preference_server_context");
        return composite;
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        String rsh = store.getString("pref_cvs_rsh");
        String parameter = store.getString("pref_cvs_rsh_parameters");
        String server = store.getString("pref_cvs_server");
        String method = store.getString("pref_ext_connection_method_proxy");
        this.initializeDefaults(rsh, parameter, server, method);
    }

    protected void setCvsRshText(String s) {
        this.cvsRsh.setText(s);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        String method;
        IPreferenceStore store = this.getPreferenceStore();
        if (this.useExternal.getSelection()) {
            method = "ext";
            store.setValue("pref_cvs_rsh", this.cvsRsh.getText());
            store.setValue("pref_cvs_rsh_parameters", this.cvsRshParameters.getText());
            store.setValue("pref_cvs_server", this.cvsServer.getText());
            CVSProviderPlugin.getPlugin().setCvsRshCommand(this.cvsRsh.getText());
            CVSProviderPlugin.getPlugin().setCvsRshParameters(this.cvsRshParameters.getText());
            CVSProviderPlugin.getPlugin().setCvsServer(this.cvsServer.getText());
        } else {
            method = this.methodType.getText();
        }
        store.setValue("pref_ext_connection_method_proxy", method);
        CVSRepositoryLocation.setExtConnectionMethodProxy((String)method);
        CVSUIPlugin.getPlugin().savePluginPreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        String rsh = store.getDefaultString("pref_cvs_rsh");
        String parameter = store.getDefaultString("pref_cvs_rsh_parameters");
        String server = store.getDefaultString("pref_cvs_server");
        String method = store.getDefaultString("pref_ext_connection_method_proxy");
        this.initializeDefaults(rsh, parameter, server, method);
        super.performDefaults();
    }

    private void initializeDefaults(String rsh, String parameters, String server, String method) {
        this.cvsRsh.setText(rsh);
        this.cvsRshParameters.setText(parameters);
        this.cvsServer.setText(server);
        IConnectionMethod[] methods = CVSRepositoryLocation.getPluggedInConnectionMethods();
        int i = 0;
        while (i < methods.length) {
            String name = methods[i].getName();
            if (!name.equals("ext")) {
                this.methodType.add(name);
            }
            ++i;
        }
        if (method.equals("ext")) {
            this.methodType.select(0);
        } else {
            this.methodType.select(this.methodType.indexOf(method));
        }
        this.useExternal.setSelection(method.equals("ext"));
        this.useInternal.setSelection(!method.equals("ext"));
        this.updateEnablements();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CVSUIPlugin.getPlugin().getPreferenceStore();
    }

    protected Button createRadioButton(Composite parent, String label, int span) {
        Button button = new Button(parent, 16);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = span;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Combo createCombo(Composite parent) {
        Combo combo = new Combo(parent, 8);
        GridData data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 1;
        combo.setLayoutData((Object)data);
        return combo;
    }
}

