/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.eclipse.xtext.ui.editor.contentassist.FQNPrefixMatcher;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.util.Strings;

public class DataPrefixMatcher
extends FQNPrefixMatcher {
    @Inject
    private PrefixMatcher.IgnoreCase delegate;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.contentassist.FQNPrefixMatcher.delimiter")
    private char delimiter = (char)46;
    @Inject
    private FQNPrefixMatcher.LastSegmentFinder lastSegmentFinder;

    public boolean isCandidateMatchingPrefix2(String name, String prefix) {
        String lastSegment = this.lastSegmentFinder.getLastSegment(name, this.delimiter);
        if (lastSegment != null) {
            if (lastSegment.startsWith(prefix)) {
                return true;
            }
            if (lastSegment.startsWith("^" + prefix)) {
                return true;
            }
        }
        return name.startsWith(prefix);
    }

    public boolean isCandidateMatchingPrefix(String name, String prefix) {
        if (this.isCandidateMatchingPrefix2(name, prefix)) {
            return true;
        }
        if (name.indexOf(this.delimiter) >= 0) {
            if (prefix.indexOf(this.delimiter) < 0) {
                String lastSegment = this.lastSegmentFinder.getLastSegment(name, this.delimiter);
                if (lastSegment != null && this.delegate.isCandidateMatchingPrefix(lastSegment, prefix)) {
                    return true;
                }
            } else {
                List splitPrefix = Strings.split((String)prefix, (char)'.');
                if (splitPrefix.isEmpty()) {
                    return false;
                }
                List splitName = Strings.split((String)name, (char)'.');
                if (splitName.size() < splitPrefix.size()) {
                    return false;
                }
                int i = 0;
                while (i < splitPrefix.size()) {
                    if (!this.delegate.isCandidateMatchingPrefix((String)splitName.get(i), (String)splitPrefix.get(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }
}

