/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import java.util.List;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.formatting2.regionaccess.HiddenRegionPartAssociation;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringBasedRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringRegion;

public class StringHidden
extends StringRegion
implements IHiddenRegionPart {
    private final AbstractHiddenRegion hiddenRegion;
    private final AbstractRule rule;
    private HiddenRegionPartAssociation association = null;

    protected StringHidden(AbstractHiddenRegion hidden, AbstractRule rule, int offset, int lenght) {
        super((StringBasedRegionAccess)hidden.getTextRegionAccess(), offset, lenght);
        this.hiddenRegion = hidden;
        this.rule = rule;
    }

    @Override
    public AbstractRule getGrammarElement() {
        return this.rule;
    }

    @Override
    public IHiddenRegion getHiddenRegion() {
        return this.hiddenRegion;
    }

    @Override
    public IHiddenRegionPart getNextHiddenPart() {
        List<IHiddenRegionPart> parts = this.hiddenRegion.getParts();
        int i = parts.indexOf(this) + 1;
        if (i < parts.size()) {
            return parts.get(i);
        }
        return null;
    }

    @Override
    public IHiddenRegionPart getPreviousHiddenPart() {
        List<IHiddenRegionPart> parts = this.hiddenRegion.getParts();
        int i = parts.indexOf(this) - 1;
        if (i > 0) {
            return parts.get(i);
        }
        return null;
    }

    protected void setAssociation(HiddenRegionPartAssociation association) {
        this.association = association;
    }

    @Override
    public HiddenRegionPartAssociation getAssociation() {
        if (this.association == null) {
            this.hiddenRegion.initAssociations();
        }
        return this.association;
    }
}

