/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.desc.util;

import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.configuration.VpDslConfigurationHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.desc.CoreModelHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.manager.VpdslDescriptionModelManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.desc.util.ECoreFileInformation;

public class ECoreResourceManager {
    public static ECoreResourceManager INSTANCE = new ECoreResourceManager();
    private Resource eCoreResource = null;
    private EPackage ePackage = null;
    private ECoreFileInformation eCoreFileInformation = null;
    private EcoreGenerationstate ecoreGenerationstate = EcoreGenerationstate.Unknown;

    public boolean generateEcoreModel(boolean load) throws Exception {
        if (!this.ecoreGenerationstate.equals((Object)EcoreGenerationstate.Unknown)) {
            return this.ecoreGenerationstate.equals((Object)EcoreGenerationstate.Generate);
        }
        Viewpoint viewpoint = VpdslDescriptionModelManager.INSTANCE.getVpDescriptionElement();
        String shortName = CoreModelHelper.getViewpointShortName((Object)viewpoint);
        String rootProjectName = VpDslConfigurationHelper.getRootProjectName((Object)viewpoint);
        this.eCoreFileInformation = new ECoreFileInformation(rootProjectName, "models", shortName);
        if (this.eCoreFileInformation.EcoreFileExist()) {
            boolean overwriteEcore;
            if (!this.areResourcesInitialized()) {
                INSTANCE.loadECoreResource(this.eCoreFileInformation);
            }
            this.ecoreGenerationstate = (overwriteEcore = VpDslConfigurationHelper.getOverwriteEcore((Object)viewpoint)) ? EcoreGenerationstate.Generate : EcoreGenerationstate.DoNotGenerate;
            return overwriteEcore;
        }
        this.ecoreGenerationstate = EcoreGenerationstate.Generate;
        return true;
    }

    public EPackage getEPackage() {
        return this.ePackage;
    }

    public Resource getEcoreResource() {
        return this.eCoreResource;
    }

    public ECoreFileInformation getECoreFileInformation() {
        return this.eCoreFileInformation;
    }

    public boolean areResourcesInitialized() {
        return this.eCoreResource != null && this.ePackage != null;
    }

    public void loadECoreResource(ECoreFileInformation arg) throws Exception {
        if (arg == null) {
            throw new InvalidParameterException("ECoreFileInformation parameter must be not null");
        }
        URI uri = arg.getEcorePlatformResourceURI();
        ResourceSetImpl rSet = new ResourceSetImpl();
        this.eCoreResource = rSet.getResource(uri, true);
        this.ePackage = (EPackage)this.eCoreResource.getContents().get(0);
    }

    public void initECoreResource() {
        this.eCoreResource = null;
        this.ePackage = null;
        this.ecoreGenerationstate = EcoreGenerationstate.Unknown;
    }

    public void saveModel() {
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        if (this.eCoreResource != null) {
            try {
                this.eCoreResource.save(saveOptions);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static enum EcoreGenerationstate {
        Generate,
        DoNotGenerate,
        Unknown;

    }
}

