/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.resource.XtextResource;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.resources.ResourceHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.util.PluginUtil;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.util.WizardsUtil;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.extensions.IConcreteSyntaxResourceCreator;

public class ResourceInitializer
implements IConcreteSyntaxResourceCreator {
    private String vpShortName;
    private String vpTargetApplication;
    private String vpDescriptionProjectName;
    private String vpRootProjectName;
    private String vpNsURI;

    public boolean createConcreteSyntaxResource(String shortName, String targetApplciation, String rootProjectName, String dslProjectName, String nsURI) {
        this.vpShortName = shortName;
        this.vpTargetApplication = targetApplciation;
        this.vpRootProjectName = rootProjectName;
        this.vpDescriptionProjectName = dslProjectName;
        this.vpNsURI = nsURI;
        return this.createResourcesAndOpenEditor();
    }

    public boolean createResourcesAndOpenEditor() {
        this.doCreateResources();
        this.bindEditors();
        IFile file = this.getWorkspaceRoot().getFile((IPath)new Path(this.computeURI("spec.vptext").toPlatformString(true)));
        if (file != null) {
            try {
                this.refreshWorkspace();
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
                return true;
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private void refreshWorkspace() {
        IProject project = this.getWorkspaceRoot().getProject(this.vpDescriptionProjectName);
        try {
            project.refreshLocal(2, ResourceInitializer.monitor());
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
    }

    private void bindEditors() {
        IFile configFile;
        IFile dataFile;
        IFile specFile = this.getWorkspaceRoot().getFile((IPath)new Path(this.computeURI("spec.vptext").toPlatformString(true)));
        if (specFile != null) {
            IDE.setDefaultEditor((IFile)specFile, (String)"org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec");
        }
        if ((dataFile = this.getWorkspaceRoot().getFile((IPath)new Path(this.computeURI("data.vptext").toPlatformString(true)))) != null) {
            IDE.setDefaultEditor((IFile)dataFile, (String)"org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Data");
        }
        if ((configFile = this.getWorkspaceRoot().getFile((IPath)new Path(this.computeURI("conf.vptext").toPlatformString(true)))) != null) {
            IDE.setDefaultEditor((IFile)configFile, (String)"org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpconf");
        }
    }

    private void doCreateResources() {
        try {
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    monitor.beginTask("Initializing viewpoint resources", -1);
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    ResourceInitializer.this.createDataResource((ResourceSet)resourceSet);
                    ResourceInitializer.this.createConfigResource((ResourceSet)resourceSet);
                    ResourceInitializer.this.createPrimaryResource((ResourceSet)resourceSet);
                    ResourceInitializer.this.addModelReuseExtensions(ResourceInitializer.this.vpDescriptionProjectName, ResourceInitializer.this.vpShortName);
                    monitor.done();
                }
            }.run(ResourceInitializer.monitor());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void createPrimaryResource(ResourceSet resourceSet) {
        URI uri = this.computeURI("spec.vptext");
        XtextResource specResource = (XtextResource)ResourceHelper.createResource((URI)uri, (ResourceSet)resourceSet);
        if (specResource != null) {
            try {
                specResource.reparse(this.getInitialSpecContent());
                specResource.save(Collections.emptyMap());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void createDataResource(ResourceSet resourceSet) {
        URI uri = this.computeURI("data.vptext");
        XtextResource specResource = (XtextResource)ResourceHelper.createResource((URI)uri, (ResourceSet)resourceSet);
        if (specResource != null) {
            try {
                specResource.reparse(this.getInitialDataContent());
                specResource.save(Collections.emptyMap());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void createConfigResource(ResourceSet resourceSet) {
        URI uri = this.computeURI("conf.vptext");
        XtextResource specResource = (XtextResource)ResourceHelper.createResource((URI)uri, (ResourceSet)resourceSet);
        if (specResource != null) {
            try {
                specResource.reparse(this.getInitialConfigurationContent());
                specResource.save(Collections.emptyMap());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public URI computeURI(String extension) {
        return ResourceHelper.computeURI((String)this.vpDescriptionProjectName, (String)this.vpShortName, (String)extension);
    }

    public String getInitialSpecContent() {
        return WizardsUtil.getInitialSpecContent(this.vpShortName);
    }

    public String getInitialConfigurationContent() {
        return WizardsUtil.getInitialConfigurationContent(this.vpShortName, this.vpTargetApplication, this.vpRootProjectName, this.vpNsURI);
    }

    public String getInitialDataContent() {
        return WizardsUtil.getInitialDataContent(this.vpShortName);
    }

    public static IProgressMonitor monitor() {
        return new NullProgressMonitor();
    }

    private void addModelReuseExtensions(String dslProjectName, String shortName) {
        PluginUtil.createModelReuseExtensionForAE((String)dslProjectName, (String)shortName);
        PluginUtil.addModelReuseExtension((String)dslProjectName, (String)shortName, (String)"spec.vptext");
        PluginUtil.addModelReuseExtension((String)dslProjectName, (String)shortName, (String)"data.vptext");
        PluginUtil.addModelReuseExtension((String)dslProjectName, (String)shortName, (String)"conf.vptext");
    }

    private void addArchitectureEvaluationExtension() {
        IProject project = this.getWorkspaceRoot().getProject(this.vpDescriptionProjectName);
        if (project.exists()) {
            PluginUtil.doCreatePluginXml((IProject)project, (String)this.vpShortName);
        }
    }

    public StringBuffer createPluginXmlContribution(String shortName, String targetApplication, String rootProjectName, String dslProjectName, String nsURI) {
        return null;
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

