/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.core.data.provider;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.swt.graphics.Image;
import org.polarsys.kitalpha.massactions.core.activator.MACoreActivator;
import org.polarsys.kitalpha.massactions.core.helper.EObjectImageProvider;

public class MAImageRowHeaderDataProvider
implements IDataProvider {
    protected IRowDataProvider<EObject> bodyDataProvider;
    protected Image defaultImage;

    public MAImageRowHeaderDataProvider(IRowDataProvider<EObject> bodyDataProvider) {
        this.bodyDataProvider = bodyDataProvider;
        this.defaultImage = MACoreActivator.getDefault().getImageRegistry().getDescriptor("DEFAULT_ROW_HEADER_ICON").createImage();
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        if (rowIndex == -1) {
            return null;
        }
        try {
            EObject rowObject = (EObject)this.bodyDataProvider.getRowObject(rowIndex);
            Image image = this.extractImage(rowObject);
            return image != null ? image : this.defaultImage;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    protected Image extractImage(EObject object) {
        return EObjectImageProvider.getInstance().getImage(object);
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        throw new UnsupportedOperationException();
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        return this.bodyDataProvider.getRowCount();
    }
}

