/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.core.config;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.export.ExportConfigAttributes;
import org.eclipse.nebula.widgets.nattable.export.csv.CsvExporter;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;

public class MAExportConfiguration
extends AbstractRegistryConfiguration {
    protected String csvDelimiter;
    protected Charset charSet;

    public MAExportConfiguration() {
        this(",");
    }

    public MAExportConfiguration(String csvDelimiter) {
        this.csvDelimiter = csvDelimiter;
        this.charSet = StandardCharsets.UTF_8;
    }

    public void configureRegistry(IConfigRegistry configRegistry) {
        CsvExporter csvExporter = new CsvExporter(){

            public void exportCell(OutputStream outputStream, Object exportDisplayValue, ILayerCell cell, IConfigRegistry configRegistry) throws IOException {
                if (cell.getColumnIndex() != 0) {
                    if (exportDisplayValue instanceof String) {
                        String escapedExportDisplayValue = StringEscapeUtils.escapeCsv((String)((String)exportDisplayValue));
                        super.exportCell(outputStream, (Object)escapedExportDisplayValue, cell, configRegistry);
                    } else {
                        super.exportCell(outputStream, exportDisplayValue, cell, configRegistry);
                    }
                }
            }
        };
        csvExporter.setDelimiter(String.valueOf(this.csvDelimiter));
        csvExporter.setCharset(this.charSet.name());
        configRegistry.registerConfigAttribute(ExportConfigAttributes.EXPORTER, (Object)csvExporter);
    }

    public void setCsvDelimiter(String csvDelimiter) {
        this.csvDelimiter = csvDelimiter;
    }

    public void setCharSet(Charset charSet) {
        this.charSet = charSet;
    }
}

