/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.activator;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.EGFCommonPlugin;
import org.eclipse.egf.common.log.IEGFLogger;
import org.eclipse.emf.common.EMFPlugin;

public class EGFEclipsePlugin
extends EMFPlugin.EclipsePlugin {
    public void log(Object object) {
        this.log(object, 0, true);
    }

    public void log(Object object, boolean appendLogger) {
        this.log(object, 0, appendLogger);
    }

    public void log(Object object, int nesting) {
        this.log(object, nesting, true);
    }

    public void log(Object logEntry, int nesting, boolean appendLogger) {
        Object innerLogEntry = logEntry;
        if (innerLogEntry instanceof IStatus) {
            IStatus status = (IStatus)innerLogEntry;
            this.logStatus(status, nesting, appendLogger);
        } else {
            if (innerLogEntry == null) {
                innerLogEntry = new RuntimeException(this.getString("_UI_NullLogEntry_exception", true)).fillInStackTrace();
            }
            if (innerLogEntry instanceof Throwable) {
                Throwable throwable = (Throwable)innerLogEntry;
                String message = throwable.getLocalizedMessage();
                if (message == null) {
                    message = "";
                }
                Status status = new Status(2, this.getBundle().getSymbolicName(), 0, message, throwable);
                this.logStatus((IStatus)status, nesting, appendLogger);
            } else {
                Status status = new Status(2, this.getBundle().getSymbolicName(), 0, innerLogEntry.toString(), null);
                this.logStatus((IStatus)status, nesting, appendLogger);
            }
        }
    }

    private void logStatus(IStatus status, int nesting, boolean appendLogger) {
        this.getLog().log(status);
        if (appendLogger) {
            for (IEGFLogger logger : EGFCommonPlugin.getEGFLoggers()) {
                logger.logStatus(status, nesting);
            }
        }
    }

    public void logInfo(String message) {
        this.logInfo(message, 0, true);
    }

    public void logInfo(String message, boolean appendLogger) {
        this.logInfo(message, 0, appendLogger);
    }

    public void logInfo(String message, int nesting) {
        this.logInfo(message, nesting, true);
    }

    public void logInfo(String message, int nesting, boolean appendLogger) {
        this.log(this.newStatus(1, message, null), nesting, appendLogger);
    }

    public void logInfo(String message, Throwable t) {
        this.logInfo(message, t, 0, true);
    }

    public void logInfo(String message, Throwable t, boolean appendLogger) {
        this.logInfo(message, t, 0, appendLogger);
    }

    public void logInfo(String message, Throwable t, int nesting) {
        this.logInfo(message, t, nesting, true);
    }

    public void logInfo(String message, Throwable t, int nesting, boolean appendLogger) {
        this.log(this.newStatus(1, message, t), nesting, appendLogger);
    }

    public void logInfo(Throwable t) {
        this.logInfo(t, 0, true);
    }

    public void logInfo(Throwable t, boolean appendLogger) {
        this.logInfo(t, 0, appendLogger);
    }

    public void logInfo(Throwable t, int nesting) {
        this.logInfo(t, nesting, true);
    }

    public void logInfo(Throwable t, int nesting, boolean appendLogger) {
        this.log(this.newStatus(1, t.getMessage(), t), nesting, appendLogger);
    }

    public void logError(String message) {
        this.logError(message, 0, true);
    }

    public void logError(String message, boolean appendLogger) {
        this.logError(message, 0, appendLogger);
    }

    public void logError(String message, int nesting) {
        this.logError(message, nesting, true);
    }

    public void logError(String message, int nesting, boolean appendLogger) {
        this.log(this.newStatus(4, message, null), nesting, appendLogger);
    }

    public void logError(String message, Throwable t) {
        this.logError(message, t, 0, true);
    }

    public void logError(String message, Throwable t, boolean appendLogger) {
        this.logError(message, t, 0, appendLogger);
    }

    public void logError(String message, Throwable t, int nesting) {
        this.logError(message, t, nesting, true);
    }

    public void logError(String message, Throwable t, int nesting, boolean appendLogger) {
        this.log(this.newStatus(4, message, t), nesting, appendLogger);
    }

    public void logError(Throwable t) {
        this.logError(t, 0, true);
    }

    public void logError(Throwable t, boolean appendLogger) {
        this.logError(t, 0, appendLogger);
    }

    public void logError(Throwable t, int nesting) {
        this.logError(t, nesting, true);
    }

    public void logError(Throwable t, int nesting, boolean appendLogger) {
        this.log(this.newStatus(4, t.getMessage(), t), nesting, appendLogger);
    }

    public void logWarning(String message) {
        this.logWarning(message, 0, true);
    }

    public void logWarning(String message, boolean appendLogger) {
        this.logWarning(message, 0, appendLogger);
    }

    public void logWarning(String message, int nesting) {
        this.logWarning(message, nesting, true);
    }

    public void logWarning(String message, int nesting, boolean appendLogger) {
        this.log(this.newStatus(2, message, null), nesting, appendLogger);
    }

    public void logWarning(String message, Throwable t) {
        this.logWarning(message, t, 0, true);
    }

    public void logWarning(String message, Throwable t, boolean appendLogger) {
        this.logWarning(message, t, 0, appendLogger);
    }

    public void logWarning(String message, Throwable t, int nesting) {
        this.logWarning(message, t, nesting, true);
    }

    public void logWarning(String message, Throwable t, int nesting, boolean appendLogger) {
        this.log(this.newStatus(2, message, t), nesting, appendLogger);
    }

    public void logWarning(Throwable t) {
        this.logWarning(t, 0, true);
    }

    public void logWarning(Throwable t, boolean appendLogger) {
        this.logWarning(t, 0, appendLogger);
    }

    public void logWarning(Throwable t, int nesting) {
        this.logWarning(t, nesting, true);
    }

    public void logWarning(Throwable t, int nesting, boolean appendLogger) {
        this.log(this.newStatus(2, t.getMessage(), t), nesting, appendLogger);
    }

    public IStatus newStatus(int severity, String message, Throwable exception) {
        return new Status(severity, this.getSymbolicName(), 0, message, exception);
    }
}

