/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.engine;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRole;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternVersion;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IDeleteOperationProvider;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IAtomicLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IElementLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IElementMappingLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IElementRelativeLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.ILocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IEvaluationStatus;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IModelTransformationStatus;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IPatternConformityStatus;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IRoleApplicabilityStatus;
import org.eclipse.emf.diffmerge.patterns.core.api.status.SimpleStatus;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.AbstractPatternData;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.AbstractPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.PatternVersion;
import org.eclipse.emf.diffmerge.patterns.core.operations.InstanceOperation;
import org.eclipse.emf.diffmerge.patterns.core.util.BasicModelUpdateSpecification;
import org.eclipse.emf.diffmerge.patterns.core.util.locations.BasicElementMappingLocation;
import org.eclipse.emf.diffmerge.patterns.templates.engine.Messages;
import org.eclipse.emf.diffmerge.patterns.templates.engine.NamingUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsEnginePlugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternApplicationComparison;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternUpdateComparison;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ITextualLanguageInterpreterFacade;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.TemplatePatternCreationSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.TemplatePatternUpdateSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.gen.ITemplatePatternEngine;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.AbstractRoleConstraint;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternData;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatepatternsFactory;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TextualRoleConstraint;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TextualRoleDerivationRule;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;

public class TemplatePatternEngine
implements ITemplatePatternEngine {
    public IRoleApplicabilityStatus checkAtomicAdditionApplicability(IAtomicLocation location_p, EObject rootTemplateElement_p) {
        SimpleStatus result;
        if (location_p instanceof IReferenceLocation) {
            IReferenceLocation containmentLocation = (IReferenceLocation)location_p;
            ISemanticRuleProvider ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor(containmentLocation.getElement());
            result = ruleProvider.supportsAdditionOf(containmentLocation.getElement(), containmentLocation.getReference(), rootTemplateElement_p, true) ? SimpleStatus.SUCCESS : new SimpleStatus(false, Messages.TemplatePatternEngine_WrongTypeForAddition);
        } else {
            result = SimpleStatus.SUCCESS;
        }
        return result;
    }

    public IRoleApplicabilityStatus checkAtomicMergeApplicability(IElementRelativeLocation location_p, EObject rootTemplateElement_p) {
        EObject modelRootElement = location_p.getElement();
        SimpleStatus result = modelRootElement != null && rootTemplateElement_p != null && modelRootElement.eClass() == rootTemplateElement_p.eClass() ? SimpleStatus.SUCCESS : new SimpleStatus(false, Messages.TemplatePatternEngine_WrongTypeForMerge);
        return result;
    }

    public IPatternConformityStatus checkConformance(TemplatePattern pattern_p, IPatternApplication application_p, List<EStructuralFeature> ignoredFeatures_p) {
        IPatternConformityStatus result = this.checkRoleConstraints(pattern_p, application_p);
        if (result.isOk()) {
            TemplatePatternApplicationComparison comparison = new TemplatePatternApplicationComparison(pattern_p, application_p, ignoredFeatures_p);
            result = comparison.checkConformity();
        }
        return result;
    }

    public IPatternConformityStatus checkConstraint(TextualRoleConstraint constraint_p, EObject element_p) {
        ITextualLanguageInterpreterFacade facade = TemplatePatternsEnginePlugin.getDefault().getLanguageFacadeFor(constraint_p.getLanguage());
        Object result = facade != null ? facade.checkElement(constraint_p, element_p) : this.getNoInterpreterStatus(constraint_p.getLanguage());
        return result;
    }

    public IPatternConformityStatus checkConstraintOnCollection(TextualRoleConstraint constraint_p, Collection<? extends EObject> elements_p) {
        SimpleStatus result = SimpleStatus.SUCCESS;
        for (EObject eObject : elements_p) {
            result = this.checkConstraint(constraint_p, eObject);
            if (result != null && result.isOk()) continue;
            String label = this.getText(eObject);
            if (label == null) break;
            result = new SimpleStatus(false, result == null ? null : String.valueOf(result.getDescription()) + " (" + label + ")");
            break;
        }
        return result;
    }

    private IPatternConformityStatus checkRoleConstraints(TemplatePattern pattern_p, IPatternApplication application_p) {
        for (TemplatePatternRole role : pattern_p.getRoles()) {
            ILocation location = null;
            if (application_p instanceof IPatternInstance && ((IPatternInstance)application_p).getPatternData() instanceof TemplatePatternData) {
                TemplatePatternData data = (TemplatePatternData)((IPatternInstance)application_p).getPatternData();
                location = new BasicElementMappingLocation();
                for (EObject templateElement : role.getTemplateElements()) {
                    EObject instanceElement = data.getCounterpart(templateElement, true);
                    if (instanceElement == null) continue;
                    ((BasicElementMappingLocation)location).map(templateElement, instanceElement);
                }
            } else {
                location = application_p.getLocation((IPatternRole)role);
            }
            for (AbstractRoleConstraint constraint : role.getConstraints()) {
                IPatternConformityStatus status = constraint.check(location);
                if (status.isOk()) continue;
                return status;
            }
        }
        return SimpleStatus.SUCCESS;
    }

    public TemplatePatternData createPatternData(TemplatePattern pattern_p, IPatternInstance instance_p, Object context_p) {
        TemplatePatternCreationSpecification traces;
        TemplatePatternData result = TemplatepatternsFactory.eINSTANCE.createTemplatePatternData();
        if (instance_p instanceof AbstractPatternInstance) {
            ((AbstractPatternInstance)instance_p).setPatternData((AbstractPatternData)result);
        }
        if ((traces = TemplatePatternsEnginePlugin.getDefault().getLastPatternCreationData()) != null) {
            if (instance_p instanceof AbstractPatternInstance) {
                ((AbstractPatternInstance)instance_p).setFolded(false);
            }
            TreeIterator it = traces.getModelScope().getAllContents();
            while (it.hasNext()) {
                EObject instanceElement = (EObject)it.next();
                EObject templateElement = traces.getCounterpart(instanceElement, false);
                result.map(instanceElement, templateElement, this.getMainMultipart());
                if (this.playsARole(templateElement, pattern_p)) continue;
                result.markAsUnfolded(instanceElement);
            }
            TemplatePatternsEnginePlugin.getDefault().clearTraces();
        } else {
            this.setupPatternDataFromApplication((IPatternApplication)instance_p, result, context_p);
        }
        result.setNamingRule(NamingUtil.getNeutralRenamingRule());
        return result;
    }

    public EList<EObject> deriveCandidateElements(TextualRoleDerivationRule rule_p, IPatternApplication context_p) {
        ITextualLanguageInterpreterFacade facade = TemplatePatternsEnginePlugin.getDefault().getLanguageFacadeFor(rule_p.getLanguage());
        EList<EObject> result = facade != null ? facade.deriveCandidateElements(rule_p, context_p) : null;
        return result;
    }

    public IModelTransformationStatus fold(TemplatePattern pattern_p, IPatternInstance instance_p) {
        SimpleStatus result = SimpleStatus.SUCCESS;
        TemplatePatternData data = TemplatePatternsUtil.getPatternData((IPatternApplication)instance_p);
        if (data != null) {
            FOrderedSet toDelete = new FOrderedSet();
            for (EObject candidate : data.getInstanceElements()) {
                if (!data.wasUnfolded(candidate)) continue;
                toDelete.add(candidate);
            }
            if (toDelete.isEmpty()) {
                result = new SimpleStatus(true, true, Messages.TemplatePatternEngine_FoldNotNeeded);
                data.clearUnfolded();
            } else {
                IDeleteOperationProvider provider = CorePatternsPlugin.getDefault().getDeleteOperationProvider();
                IModelOperation deleteOperation = provider.getDeleteOperation((Collection)toDelete, false, false, data.getScopeElement());
                result = (IModelTransformationStatus)deleteOperation.run(null);
                if (result.isOk() && !result.hasWarnings()) {
                    data.clearUnfolded();
                }
            }
        }
        return result;
    }

    public String getMainMultipart() {
        return "MAIN";
    }

    private SimpleStatus getNoInterpreterStatus(String language_p) {
        return new SimpleStatus(false, String.format(Messages.TemplatePatternEngine_NoInterpreter, language_p));
    }

    private String getText(EObject element_p) {
        AdapterFactoryEditingDomain editingDomain;
        IItemLabelProvider provider;
        String result = null;
        EditingDomain rawEditingDomain = CorePatternsPlugin.getDefault().getModelEnvironment().getEditingDomain(element_p);
        if (rawEditingDomain instanceof AdapterFactoryEditingDomain && (provider = (IItemLabelProvider)(editingDomain = (AdapterFactoryEditingDomain)rawEditingDomain).getAdapterFactory().adapt((Notifier)element_p, IItemLabelProvider.class)) != null) {
            result = provider.getText((Object)element_p);
        }
        return result;
    }

    private boolean isRelevantNamingRule(String namingRule_p) {
        return namingRule_p != null && namingRule_p.length() > 0 && !NamingUtil.getNeutralRenamingRule().equals(namingRule_p);
    }

    private boolean playsARole(EObject templateElement_p, TemplatePattern pattern_p) {
        for (TemplatePatternRole role : pattern_p.getRoles()) {
            if (!role.getTemplateElements().contains((Object)templateElement_p)) continue;
            return true;
        }
        return false;
    }

    public IModelTransformationStatus unfold(TemplatePattern pattern_p, IPatternInstance instance_p) {
        BasicModelUpdateSpecification specification = new BasicModelUpdateSpecification();
        ISemanticRuleProvider ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor(null);
        if (ruleProvider != null) {
            List<EStructuralFeature> features = ruleProvider.getDefaultOptionalMergeFeatures();
            for (EStructuralFeature feature : features) {
                specification.getFeaturesToIgnore().add(feature);
            }
        }
        return this.updateModel(pattern_p, instance_p, (IPattern.IModelUpdateSpecification)specification);
    }

    public IModelTransformationStatus updateModel(TemplatePattern pattern_p, IPatternInstance instance_p, IPattern.IModelUpdateSpecification specification_p) {
        TemplatePatternApplicationComparison comparison = new TemplatePatternApplicationComparison(pattern_p, (IPatternApplication)instance_p, (List<EStructuralFeature>)specification_p.getFeaturesToIgnore());
        IModelTransformationStatus result = comparison.updateApplication(specification_p.isDestructive());
        if (result.isOk()) {
            IPatternVersion instanceVersion = instance_p.getPatternVersion();
            if (instanceVersion instanceof PatternVersion) {
                ((PatternVersion)instanceVersion).setVersion(pattern_p.getVersion());
            }
            String namingRule = null;
            TemplatePatternData data = TemplatePatternsUtil.getPatternData((IPatternApplication)instance_p);
            if (data != null) {
                namingRule = data.getNamingRule();
            }
            if (this.isRelevantNamingRule(namingRule)) {
                this.renameElements(instance_p, result.getAddedElements(), namingRule, false);
            }
        }
        return result;
    }

    private void setupPatternDataFromApplication(IPatternApplication application_p, TemplatePatternData data_p, Object context_p) {
        IPattern pattern = application_p.getPattern();
        if (pattern != null) {
            EditingDomain medt = AdapterFactoryEditingDomain.getEditingDomainFor((Object)context_p);
            for (IPatternRole pRole : pattern.getRoles()) {
                TemplatePatternRole role;
                ILocation location;
                if (!(pRole instanceof TemplatePatternRole) || (location = application_p.getLocation((IPatternRole)(role = (TemplatePatternRole)pRole))) == null) continue;
                List atomicLocations = location.getAtomicContents();
                for (IAtomicLocation atomicLocation : atomicLocations) {
                    if (atomicLocation instanceof IElementLocation) {
                        EObject modelElement = ((IElementLocation)atomicLocation).getElement(context_p);
                        EObject templateElement = (EObject)role.getTemplateElements().get(0);
                        String multipart = this.getMainMultipart();
                        if (atomicLocations.size() > 1) {
                            multipart = CorePatternsPlugin.getDefault().getIdProvider().getId(modelElement, medt);
                        }
                        data_p.map(modelElement, templateElement, multipart);
                        continue;
                    }
                    if (!(atomicLocation instanceof IElementMappingLocation)) continue;
                    IElementMappingLocation mappingLocation = (IElementMappingLocation)atomicLocation;
                    String multipart = this.getMainMultipart();
                    for (EObject patternElement : mappingLocation.getPatternElements(pattern)) {
                        EObject modelElement = mappingLocation.getElement(patternElement);
                        if (modelElement == null) continue;
                        data_p.map(modelElement, patternElement, multipart);
                    }
                }
            }
        }
    }

    public TemplatePatternUpdateComparison updatePattern(final TemplatePatternUpdateSpecification specification_p) {
        final TemplatePatternUpdateComparison comparison = new TemplatePatternUpdateComparison(specification_p);
        IStatus status = comparison.updatePattern();
        if (status.isOK()) {
            InstanceOperation updateInstanceOperation = new InstanceOperation(specification_p.getInstance(), null, null, specification_p.getInstance(), null){

                protected IEvaluationStatus run() {
                    this.extendPatternData();
                    IPatternVersion instanceVersion = specification_p.getInstance().getPatternVersion();
                    if (instanceVersion instanceof PatternVersion) {
                        ((PatternVersion)instanceVersion).setVersion(specification_p.getOriginalPattern().getVersion());
                        return new SimpleStatus(true, "Instance version updated");
                    }
                    return new SimpleStatus(false, "Couldn't update instance version");
                }

                private void extendPatternData() {
                    TemplatePatternApplicationComparison applicationComparison = specification_p.getComparison();
                    TemplatePatternData data = applicationComparison.getPatternData();
                    Role applicationRole = TemplatePatternApplicationComparison.getApplicationRole();
                    if (data != null) {
                        Collection<IMatch> updatedMatches = applicationComparison.getUpdatedMatches();
                        for (IMatch match : updatedMatches) {
                            EObject instanceElement = match.get(applicationRole);
                            EObject intermediateTemplateElement = match.get(TemplatePatternUpdateComparison.getPatternRole());
                            IMatch patternMatch = comparison.getMapping().getMatchFor(intermediateTemplateElement, applicationRole);
                            if (patternMatch == null) continue;
                            EObject templateElement = patternMatch.get(TemplatePatternUpdateComparison.getPatternRole());
                            String mappingMultipart = applicationComparison.getMainMultipart();
                            if (!comparison.getPattern().isUnique(templateElement) && applicationComparison.getCurrentMultipart() != null) {
                                mappingMultipart = applicationComparison.getCurrentMultipart();
                            }
                            data.map(instanceElement, templateElement, mappingMultipart);
                            data.markAsUnfolded(instanceElement);
                        }
                    }
                }
            };
            IEvaluationStatus result = (IEvaluationStatus)CorePatternsPlugin.getDefault().getModelEnvironment().execute((IModelOperation)updateInstanceOperation);
            result.isOk();
        }
        return comparison;
    }

    public void renameElements(IPatternInstance instance_p, String newNamingRule_p, boolean keepUserNames_p) {
        this.renameElements(instance_p, instance_p.getElements(), newNamingRule_p, keepUserNames_p);
    }

    private void renameElements(IPatternInstance instance_p, Collection<EObject> elementsToRename_p, String newNamingRule_p, boolean keepUserNames_p) {
        TemplatePatternData data = TemplatePatternsUtil.getPatternData((IPatternApplication)instance_p);
        if (data != null) {
            ISemanticRuleProvider ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor(instance_p.getScopeElement());
            Collection<EObject> toRename = ruleProvider.getElementsToRename(elementsToRename_p);
            if (toRename != null) {
                for (EObject instanceElement : toRename) {
                    EObject templateElement;
                    String defaultName = null;
                    if (instance_p.getPattern() != null && (templateElement = data.getCounterpart(instanceElement, false)) != null) {
                        defaultName = NamingUtil.getName(templateElement);
                    }
                    NamingUtil.applyRenamingRule(instanceElement, newNamingRule_p, keepUserNames_p, data.getNamingRule(), defaultName);
                }
            }
            data.setNamingRule(newNamingRule_p);
        }
    }
}

