/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.support.contributions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternBasedBijection;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternData;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRole;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IPatternSupport;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IAtomicLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IElementRelativeLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.ILocation;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.AbstractLocation;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.CorepatternsFactory;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.PatternSymbol;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.PatternVersion;
import org.eclipse.emf.diffmerge.patterns.core.util.LocationsUtil;
import org.eclipse.emf.diffmerge.patterns.support.environment.DefaultModelEnvironment;
import org.eclipse.emf.diffmerge.patterns.support.gen.CommonPatternSupportAdapter;
import org.eclipse.emf.diffmerge.patterns.support.gen.commonpatternsupport.CommonPatternInstance;
import org.eclipse.emf.diffmerge.patterns.support.gen.commonpatternsupport.CommonPatternInstanceSet;
import org.eclipse.emf.diffmerge.patterns.support.gen.commonpatternsupport.CommonpatternsupportFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class DefaultPatternSupport
implements IPatternSupport {
    protected abstract CommonPatternInstanceSet getInstanceSet(Resource var1, boolean var2);

    public boolean isApplicableTo(EObject element_p) {
        DefaultModelEnvironment environment = new DefaultModelEnvironment();
        return element_p instanceof CommonPatternInstance || environment.isModelElement(element_p);
    }

    public boolean isApplicableTo(IPatternApplication application_p) {
        Collection<IAtomicLocation> locations = this.getAtomicLocations(application_p);
        for (IAtomicLocation location : locations) {
            IElementRelativeLocation castedLocation;
            if (!(location instanceof IElementRelativeLocation) || !this.isApplicableTo((castedLocation = (IElementRelativeLocation)location).getElement())) continue;
            return true;
        }
        return application_p.getScopeElement() instanceof EObject && this.isApplicableTo((EObject)application_p.getScopeElement());
    }

    public CommonPatternInstance createInstance(IPatternApplication application_p) {
        CommonPatternInstance result = CommonpatternsupportFactory.eINSTANCE.createCommonPatternInstance();
        result.setFolded(true);
        IPattern pattern = application_p.getPattern();
        PatternSymbol patternSymbol = CommonPatternSupportAdapter.COMMON_PATTERN_SUPPORT_ADAPTER.adapt(pattern.getSymbol());
        PatternVersion patternVersion = CorepatternsFactory.eINSTANCE.createPatternVersion();
        patternVersion.setPatternSymbol(patternSymbol);
        patternVersion.setVersion(pattern.getVersion());
        result.setPatternVersion(patternVersion);
        for (IPatternRole role : pattern.getRoles()) {
            ILocation location = application_p.getLocation(role);
            this.setLocation(role, result, location);
        }
        this.storeOwnInstance(result, application_p.getScopeElement());
        pattern.createDataFor((IPatternInstance)result, application_p.getScopeElement());
        return result;
    }

    protected CommonPatternInstanceSet getCreateInstanceSet(Object context_p) {
        Resource resource = this.getResourceForStorage(context_p);
        assert (resource != null);
        return this.getInstanceSet(resource, true);
    }

    protected Resource getResourceForStorage(Object context_p) {
        Resource result = null;
        if (context_p instanceof EObject) {
            result = EcoreUtil.getRootContainer((EObject)((EObject)context_p)).eResource();
        } else if (context_p instanceof Resource) {
            result = (Resource)context_p;
        }
        return result;
    }

    protected Resource getResourceForStorageFromElement(EObject element_p) {
        Resource result = null;
        if (this.isApplicableTo(element_p)) {
            EObject root = EcoreUtil.getRootContainer((EObject)element_p);
            result = root.eResource();
        }
        return result;
    }

    protected boolean storeOwnInstance(CommonPatternInstance instance_p, Object context_p) {
        boolean result = false;
        CommonPatternInstanceSet instanceSet = this.getCreateInstanceSet(context_p);
        if (instanceSet != null) {
            instanceSet.getOwnedInstances().add((Object)instance_p);
            result = true;
        }
        return result;
    }

    public List<IPatternInstance> getAllInstances(Object context_p) {
        CommonPatternInstanceSet instanceSet;
        Object result = Collections.emptyList();
        Resource resource = this.getResourceForStorage(context_p);
        if (resource != null && (instanceSet = this.getInstanceSet(resource, false)) != null) {
            result = instanceSet.getOwnedInstances();
            result = Collections.unmodifiableList(result);
        }
        return result;
    }

    public List<IPatternInstance> getRelatedInstances(EObject element_p) {
        List<IPatternInstance> result = this.getRelatedInstancesFromElement(element_p);
        return result;
    }

    protected List<IPatternInstance> getRelatedInstancesFromElement(EObject element_p) {
        CommonPatternInstanceSet instanceSet;
        ArrayList<IPatternInstance> result = new ArrayList<IPatternInstance>();
        Resource storageResource = this.getResourceForStorageFromElement(element_p);
        if (storageResource != null && (instanceSet = this.getInstanceSet(storageResource, false)) != null) {
            for (IPatternInstance instance : instanceSet.getOwnedInstances()) {
                IPatternBasedBijection bijection;
                if (LocationsUtil.getRoleElements((IPatternApplication)instance).contains(element_p)) {
                    result.add(instance);
                    continue;
                }
                IPatternData data = instance.getPatternData();
                if (!(data instanceof IPatternBasedBijection) || !(bijection = (IPatternBasedBijection)data).covers(element_p, false)) continue;
                result.add(instance);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public boolean hasRelatedInstances(EObject element_p) {
        CommonPatternInstanceSet instanceSet;
        Resource storageResource = this.getResourceForStorageFromElement(element_p);
        if (storageResource != null && (instanceSet = this.getInstanceSet(storageResource, false)) != null) {
            for (IPatternInstance instance : instanceSet.getOwnedInstances()) {
                IPatternBasedBijection bijection;
                if (LocationsUtil.getRoleElements((IPatternApplication)instance).contains(element_p)) {
                    return true;
                }
                IPatternData data = instance.getPatternData();
                if (!(data instanceof IPatternBasedBijection) || !(bijection = (IPatternBasedBijection)data).covers(element_p, false)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean storeInstance(IPatternInstance instance_p, Object context_p) {
        boolean result = false;
        if (instance_p instanceof CommonPatternInstance) {
            result = this.storeOwnInstance((CommonPatternInstance)instance_p, context_p);
        }
        return result;
    }

    protected Collection<IAtomicLocation> getAtomicLocations(IPatternApplication application_p) {
        ArrayList result = new ArrayList();
        Collection locations = application_p.getLocations();
        for (ILocation location : locations) {
            result.addAll(location.getAtomicContents());
        }
        return Collections.unmodifiableCollection(result);
    }

    protected void setLocation(IPatternRole role_p, CommonPatternInstance instance_p, ILocation location_p) {
        if (location_p != null) {
            AbstractLocation mdeLocation = CommonPatternSupportAdapter.COMMON_PATTERN_SUPPORT_ADAPTER.adapt(location_p, role_p.getPattern());
            instance_p.setLocation(role_p, mdeLocation);
        }
    }
}

