/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.table.metamodel.table.description.CrossTableDescription;
import org.eclipse.sirius.table.metamodel.table.description.EditionTableDescription;
import org.eclipse.sirius.tools.api.interpreter.IInterpreterMessages;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NewRepresentationAction
extends BaseSelectionListenerAction {
    private EObject selectedEObject;
    protected RepresentationDescription description;
    protected Session session;
    protected boolean forceDefaultName;
    protected boolean openRepresentation;
    protected final Collection<Layer> extraLayers;
    private Collection<FilterDescription> extraFilters;

    public NewRepresentationAction(RepresentationDescription description, EObject selectedEObject, Session session) {
        this(description, selectedEObject, session, false, true);
    }

    public NewRepresentationAction(RepresentationDescription description, EObject selectedEObject, Session session, boolean forceDefaultName, boolean openRepresentation) {
        this(description, selectedEObject, session, forceDefaultName, openRepresentation, Collections.emptyList(), Collections.emptyList());
    }

    public NewRepresentationAction(RepresentationDescription description, EObject selectedEObject, Session session, boolean forceDefaultName, boolean openRepresentation, Collection<Layer> extraLayers, Collection<FilterDescription> extraFilters) {
        super(description.getName());
        String label = description.getLabel();
        if (label != null && label.length() > 1) {
            this.setText(label);
        }
        ImageDescriptor imageDescriptor = null;
        imageDescriptor = description instanceof CrossTableDescription ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.table.ui", (String)"/icons/full/obj16/CrossTableDescription.gif") : (description instanceof EditionTableDescription ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.table.ui", (String)"/icons/full/obj16/DTable.gif") : AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/obj16/DAnalysis.gif"));
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        this.setImageDescriptor(imageDescriptor);
        this.selectedEObject = selectedEObject;
        this.description = description;
        this.session = session;
        this.forceDefaultName = forceDefaultName;
        this.openRepresentation = openRepresentation;
        this.extraLayers = extraLayers;
        this.extraFilters = extraFilters;
    }

    public void run() {
        String defaultName = this.computeDefaultName(this.selectedEObject, this.description);
        if (!this.forceDefaultName) {
            String label = this.description.getLabel();
            if (label == null || label.isEmpty()) {
                label = this.description.getName();
            }
            String dialogTitle = "New " + label;
            String dialogMessage = "Name:";
            Shell activeShell = Display.getDefault().getActiveShell();
            InputDialog representationNameDlg = new InputDialog(activeShell, dialogTitle, dialogMessage, defaultName, null);
            if (representationNameDlg.open() == 0) {
                defaultName = representationNameDlg.getValue();
            } else {
                throw new OperationCanceledException();
            }
        }
        NewRepresentationCommand command = new NewRepresentationCommand(defaultName, this.selectedEObject, this.description, this.session, this.extraLayers, this.extraFilters);
        TransactionUtil.getEditingDomain((EObject)this.selectedEObject).getCommandStack().execute((Command)command);
        if (command.getRepresentation() != null) {
            SessionManager.INSTANCE.notifyRepresentationCreated(this.session);
            if (this.openRepresentation) {
                DialectUIManager.INSTANCE.openEditor(this.session, command.getRepresentation(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    protected String computeDefaultName(EObject eObject, RepresentationDescription repDescription) {
        IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)eObject);
        String newName = "New ";
        newName = !StringUtil.isEmpty((String)repDescription.getLabel()) ? String.valueOf(newName) + repDescription.getLabel() : String.valueOf(newName) + repDescription.getName();
        String titleExpression = repDescription.getTitleExpression();
        if (!StringUtil.isEmpty((String)titleExpression)) {
            try {
                newName = interpreter.evaluateString(eObject, titleExpression);
            }
            catch (EvaluationException e) {
                SiriusPlugin.getDefault().error(IInterpreterMessages.EVALUATION_ERROR_ON_MODEL_MODIFICATION, (Throwable)e);
            }
        }
        return newName;
    }

    private class NewRepresentationCommand
    extends RecordingCommand {
        private String newName;
        private DRepresentation representation;
        private EObject eObject;
        private RepresentationDescription repDescription;
        private Session currentSession;
        private Collection<Layer> extraLayers;
        private Collection<FilterDescription> extraFilters;

        public NewRepresentationCommand(String newName, EObject eObject, RepresentationDescription repDescription, Session session, Collection<Layer> extraLayers, Collection<FilterDescription> extraFilters) {
            super(TransactionUtil.getEditingDomain((EObject)eObject));
            this.newName = newName;
            this.eObject = eObject;
            this.repDescription = repDescription;
            this.currentSession = session;
            this.extraLayers = extraLayers;
            this.extraFilters = extraFilters;
        }

        public void commandInterrupted() {
            this.commandRolledBack();
        }

        public void commandRolledBack() {
            this.representation = null;
        }

        public DRepresentation getRepresentation() {
            return this.representation;
        }

        public void doExecute() {
            NullProgressMonitor monitor = new NullProgressMonitor();
            this.representation = DialectManager.INSTANCE.createRepresentation(this.newName, this.eObject, this.repDescription, this.currentSession, (IProgressMonitor)monitor);
            if (this.representation instanceof DDiagram) {
                ((DDiagram)this.representation).getActivatedLayers().addAll(this.extraLayers);
                ((DDiagram)this.representation).getActivatedFilters().addAll(this.extraFilters);
            }
        }
    }
}

