/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.impl.build;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Text;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.AbstractThirdPage;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.impl.build.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.impl.build.VpbuildWizard;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.util.WizardsUtil;

public class VpbuildThirdPage
extends AbstractThirdPage {
    private Text vpRootProjectNameText;
    private Text vpDescriptionProjectNameText;

    public VpbuildThirdPage() {
        super(Messages.VpbuildFileThirdPage_Title);
    }

    public VpbuildThirdPage(ISelection selection) {
        super(Messages.VpbuildFileThirdPage_Title);
    }

    @Override
    protected void initializeProperties() {
        this.setVpRootProjectNameText(this.createTextProperty("Root project name:", ((VpbuildWizard)this.getWizard()).getVpRootProjectName(), false));
        this.setVpDescriptionProjectNameText(this.createTextProperty("Viewpoint project name:", ((VpbuildWizard)this.getWizard()).getVpDescriptionProjectName(), false));
    }

    @Override
    protected boolean dataChanged() {
        String msg = "Only [a-z A-Z 0-9 _ -] character are allowed";
        if (!WizardsUtil.isValid(this.vpDescriptionProjectNameText.getText(), true)) {
            this.updateStatus("Description project name must be valid: " + msg);
            return false;
        }
        if (!WizardsUtil.isValid(this.vpRootProjectNameText.getText(), true)) {
            this.updateStatus("Root project name must be valid: " + msg);
            return false;
        }
        IProject descProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getVpDescriptionProjectNameText().getText());
        IProject rootProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getVpRootProjectNameText().getText());
        if (descProject.exists()) {
            this.updateStatus(null);
            return true;
        }
        if (rootProject.exists()) {
            this.updateStatus("Project \"" + rootProject.getName() + "\" exists already");
            return false;
        }
        this.updateStatus(null);
        return true;
    }

    public Text getVpRootProjectNameText() {
        return this.vpRootProjectNameText;
    }

    public void setVpRootProjectNameText(Text vpRootProjectNameText) {
        this.vpRootProjectNameText = vpRootProjectNameText;
    }

    public Text getVpDescriptionProjectNameText() {
        return this.vpDescriptionProjectNameText;
    }

    public void setVpDescriptionProjectNameText(Text vpDescriptionProjectNameText) {
        this.vpDescriptionProjectNameText = vpDescriptionProjectNameText;
    }
}

