/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.visualize.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.polarsys.kitalpha.massactions.visualize.query.AQLQuery;
import org.polarsys.kitalpha.massactions.visualize.query.IQuery;
import org.polarsys.kitalpha.massactions.visualize.query.QueryParameter;

public class QueryRegistry {
    private static final Log log = LogFactory.getLog(QueryRegistry.class);
    private static QueryRegistry instance = null;
    protected Map<String, IQuery> registry = new HashMap<String, IQuery>();

    public static QueryRegistry getInstance() {
        if (instance == null) {
            instance = new QueryRegistry();
        }
        return instance;
    }

    protected QueryRegistry() {
        this.initializeRegistry();
    }

    protected void initializeRegistry() {
        IQuery sampleQuery = this.createSampleQuery();
        this.registry.put(sampleQuery.getName(), sampleQuery);
    }

    private IQuery createSampleQuery() {
        String sampleQuery = "aql:diagram.name + ' -> ' + pv.name";
        QueryParameter diagramParameter = new QueryParameter();
        diagramParameter.setName("diagram");
        QueryParameter pvParameter = new QueryParameter();
        pvParameter.setName("pv");
        AQLQuery query = new AQLQuery();
        query.setQuery(sampleQuery);
        query.setParameters(diagramParameter, pvParameter);
        query.setName("XXX");
        return query;
    }

    public IQuery getQuery(String name) {
        return this.registry.get(name);
    }

    public Set<IQuery> getValidQueries(int[] columnPositions) {
        log.info((Object)columnPositions);
        return Collections.emptySet();
    }
}

