/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.flow.impl;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.eef.codegen.flow.Step;
import org.eclipse.emf.eef.codegen.flow.var.WorkflowVariable;

public abstract class GenerateEMFCode
extends Step {
    private Object genmodel;
    private WorkflowVariable genProjectVar;

    public GenerateEMFCode(String name, Object genmodel) {
        super(name);
        this.genmodel = genmodel;
    }

    protected GenModel getGenModel() {
        if (this.genmodel instanceof GenModel) {
            return (GenModel)this.genmodel;
        }
        if (this.genmodel instanceof WorkflowVariable && ((WorkflowVariable)this.genmodel).getValue() instanceof GenModel) {
            return (GenModel)((WorkflowVariable)this.genmodel).getValue();
        }
        return null;
    }

    public IStatus execute(IProgressMonitor monitor) {
        try {
            if (this.getGenModel() != null) {
                this.getGenModel().setCanGenerate(true);
                this.generateModelCode(this.getGenModel());
                this.valuateGenerationProject();
                return Status.OK_STATUS;
            }
            return new Status(4, "org.eclipse.emf.eef.codegen", "Unable to find the generated GenModel.");
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.emf.eef.codegen", "An error occured during EMF code generation.", (Throwable)e);
        }
    }

    protected abstract void valuateGenerationProject();

    public Object genProject() {
        if (this.genProjectVar == null) {
            this.genProjectVar = new WorkflowVariable(this.genprojectVarName());
        }
        return this.genProjectVar;
    }

    protected void generateModelCode(GenModel genModel) {
        Generator generator = GenModelUtil.createGenerator((GenModel)genModel);
        this.invokeGeneration(genModel, generator);
    }

    protected abstract String genprojectVarName();

    protected IProject extractProject(String sPath) {
        Path path = new Path(sPath);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.getRoot().getProject(path.segment(0));
    }

    protected abstract void invokeGeneration(GenModel var1, Generator var2);
}

