/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.resource;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.egf.core.domain.TargetPlatformResourceSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.exception.ViewpointResourceException;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.resource.IViewpointResourceProvider;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.resourceimpl.ViewpointResourceProviderRegistry;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.types.ResourceFileInformation;

public abstract class AbstractCoreResourceProvider
implements IViewpointResourceProvider {
    private ViewpointResourceProviderRegistry handler_;
    private ResourceFileInformation coreResourceInformation_;
    private Resource resource_;

    @Override
    public Resource getResource() throws ViewpointResourceException {
        if (this.resource_ != null && !this.resource_.isLoaded()) {
            try {
                this.resource_.load(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                ViewpointResourceException exception = new ViewpointResourceException(this.getResourceFileInformations(), 20);
                exception.setStackTrace(e.getStackTrace());
                throw exception;
            }
        }
        try {
            this.loadResourceFromFile();
        }
        catch (Exception e) {
            ViewpointResourceException exception = new ViewpointResourceException(this.getResourceFileInformations(), 20);
            exception.setStackTrace(e.getStackTrace());
            throw exception;
        }
        return this.resource_;
    }

    @Override
    public ResourceFileInformation getResourceFileInformations() {
        return this.coreResourceInformation_;
    }

    @Override
    public void setResourceFileInformations(ResourceFileInformation resourceFileInformation) throws ViewpointResourceException {
        if (this.coreResourceInformation_ == null || this.coreResourceInformation_ != resourceFileInformation) {
            this.coreResourceInformation_ = resourceFileInformation;
            try {
                this.loadResourceFromFile();
            }
            catch (Exception e) {
                ViewpointResourceException exception = new ViewpointResourceException(this.getResourceFileInformations(), 20);
                exception.setStackTrace(e.getStackTrace());
                throw exception;
            }
        }
    }

    @Override
    public EObject getRootElement() throws ViewpointResourceException {
        if (this.resource_ == null) {
            throw new ViewpointResourceException(this.getResourceFileInformations(), 10);
        }
        EList content = this.resource_.getContents();
        if (content.size() == 0) {
            throw new ViewpointResourceException(this.getResourceFileInformations(), 1);
        }
        return (EObject)content.get(0);
    }

    @Override
    public ViewpointResourceProviderRegistry getHandler() {
        return this.handler_;
    }

    public void setHandler(ViewpointResourceProviderRegistry handler) {
        this.handler_ = handler;
    }

    protected void loadResourceFromFile() {
        URI uri = this.coreResourceInformation_.getPlatformResourceURI();
        TargetPlatformResourceSet resourceSet = new TargetPlatformResourceSet();
        this.resource_ = resourceSet.getResource(uri, true);
    }

    @Override
    public void refresh() {
        this.resource_.unload();
        try {
            this.resource_.load(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

