/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;

public abstract class HeaderViewer<V extends Viewer>
extends Viewer {
    private Composite _control;
    private V _innerViewer;
    private Label _image;
    private Label _text;
    private ToolBar _toolbar;

    public void addSelectionChangedListener(ISelectionChangedListener listener_p) {
        this.getInnerViewer().addSelectionChangedListener(listener_p);
    }

    public void addSWTSelectionListener(SelectionListener listener_p) {
        TypedListener typedListener = new TypedListener((SWTEventListener)listener_p);
        Control innerControl = this.getInnerViewer().getControl();
        innerControl.addListener(13, (Listener)typedListener);
        innerControl.addListener(14, (Listener)typedListener);
    }

    protected void createControls(Composite parent_p) {
        this._control = UIUtil.createComposite(parent_p);
        Composite headerComposite = new Composite(this._control, 0);
        headerComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        headerComposite.setLayout((Layout)layout);
        this._innerViewer = this.createInnerViewer(this._control);
        this.createHeaderContent(headerComposite);
    }

    protected void createHeaderContent(Composite parent_p) {
        boolean isToolBarOnTheRight = this.isToolBarOnTheRight();
        if (!isToolBarOnTheRight) {
            this._toolbar = this.createToolBar(parent_p);
        }
        Composite textImageComposite = new Composite(parent_p, 0);
        textImageComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout nameHeaderLayout = new GridLayout(3, false);
        nameHeaderLayout.marginTop = nameHeaderLayout.marginHeight;
        nameHeaderLayout.marginHeight = 0;
        nameHeaderLayout.marginWidth = 0;
        textImageComposite.setLayout((Layout)nameHeaderLayout);
        this._image = this.createImageLabel(textImageComposite);
        this._text = this.createTextLabel(textImageComposite);
        if (isToolBarOnTheRight) {
            Label space = new Label(textImageComposite, 64);
            space.setLayoutData((Object)new GridData(4, 4, false, false));
            this._toolbar = this.createToolBar(parent_p);
        }
    }

    protected Label createImageLabel(Composite parent_p) {
        Label result = new Label(parent_p, 0);
        return result;
    }

    protected abstract V createInnerViewer(Composite var1);

    protected Label createTextLabel(Composite parent_p) {
        Label result = new Label(parent_p, 0);
        result.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return result;
    }

    protected ToolBar createToolBar(Composite parent_p) {
        return UIUtil.createToolBar(parent_p);
    }

    public Control getControl() {
        return this._control;
    }

    public String getHeaderText() {
        String result = null;
        Label headerLabel = this.getTextLabel();
        if (headerLabel != null && !headerLabel.isDisposed()) {
            result = headerLabel.getText();
        }
        return result;
    }

    public Label getImageLabel() {
        return this._image;
    }

    public V getInnerViewer() {
        return this._innerViewer;
    }

    public Object getInput() {
        return this.getInnerViewer().getInput();
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getInnerViewer().getSelection();
    }

    public Label getTextLabel() {
        return this._text;
    }

    public ToolBar getToolbar() {
        return this._toolbar;
    }

    protected void inputChanged(Object input_p, Object oldInput_p) {
        if (!this._innerViewer.getControl().isDisposed()) {
            this._innerViewer.setInput(input_p);
        }
    }

    protected boolean isToolBarOnTheRight() {
        return true;
    }

    public void refresh() {
        if (!this._innerViewer.getControl().isDisposed()) {
            this._innerViewer.refresh();
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener_p) {
        this.getInnerViewer().removeSelectionChangedListener(listener_p);
    }

    public boolean setHeaderText(String text_p) {
        boolean result = false;
        Label headerLabel = this.getTextLabel();
        if (headerLabel != null && !headerLabel.isDisposed()) {
            headerLabel.setText(text_p);
            result = true;
        }
        return result;
    }

    public final void setInput(Object input_p) {
        Object oldInput = this.getInput();
        this.inputChanged(input_p, oldInput);
    }

    public void setSelection(ISelection selection_p, boolean reveal_p) {
        if (!this._innerViewer.getControl().isDisposed()) {
            this._innerViewer.setSelection(selection_p, reveal_p);
        }
    }
}

