/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecoretools.design.service.DiagnosticAttachment;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class LiveValidationTrigger
implements ModelChangeTrigger {
    public static final NotificationFilter IS_ECORE_CHANGE = new NotificationFilter.Custom(){

        public boolean matches(Notification notification) {
            return !notification.isTouch() && notification.getFeature() instanceof EStructuralFeature && ((EStructuralFeature)notification.getFeature()).getEContainingClass().getEPackage() == EcorePackage.eINSTANCE;
        }
    };
    private TransactionalEditingDomain domain;
    public static final int PRIORITY = 0;

    public LiveValidationTrigger(TransactionalEditingDomain domain) {
        this.domain = domain;
    }

    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        final LinkedHashSet changedEcoreObjects = Sets.newLinkedHashSet();
        for (Notification notif : notifications) {
            Object obj = notif.getNotifier();
            if (!(obj instanceof EObject) || ((EObject)obj).eClass() == null || ((EObject)obj).eClass().getEPackage() != EcorePackage.eINSTANCE) continue;
            changedEcoreObjects.add((EObject)obj);
        }
        if (changedEcoreObjects.size() > 0) {
            RecordingCommand revalidateEObjects = new RecordingCommand(this.domain){

                protected void doExecute() {
                    LinkedHashSet containers = Sets.newLinkedHashSet();
                    for (EObject eObj : changedEcoreObjects) {
                        this.revalidate(eObj);
                        EObject container = eObj.eContainer();
                        if (container == null) continue;
                        containers.add(container);
                        if (!(eObj instanceof EParameter) && !(eObj instanceof EStringToStringMapEntryImpl) || !(container.eContainer() instanceof EClass)) continue;
                        containers.add(container.eContainer());
                    }
                    for (EObject container : containers) {
                        this.revalidate(container);
                    }
                }

                protected void revalidate(EObject eObj) {
                    DiagnosticAttachment diag = DiagnosticAttachment.getAttachment(eObj);
                    if (diag != null) {
                        try {
                            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObj);
                            diag.setDiagnostic(diagnostic);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            };
            return Options.newSome((Object)revalidateEObjects);
        }
        return Options.newNone();
    }

    public int priority() {
        return 0;
    }
}

