/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout.data.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ILayoutDataManagerProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.layout.SiriusLayoutDataManagerForSemanticElementsFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.data.extension.LayoutDataManagerDescriptor;

public final class LayoutDataManagerRegistry {
    private static final Map<LayoutDataManagerDescriptor, SiriusLayoutDataManager> EXTENSIONS = new LinkedHashMap<LayoutDataManagerDescriptor, SiriusLayoutDataManager>();

    private LayoutDataManagerRegistry() {
    }

    public static void addExtension(LayoutDataManagerDescriptor extension) {
        EXTENSIONS.put(extension, null);
    }

    public static void clearRegistry() {
        EXTENSIONS.clear();
    }

    public static Collection<LayoutDataManagerDescriptor> getRegisteredExtensions() {
        return new ArrayList<LayoutDataManagerDescriptor>(EXTENSIONS.keySet());
    }

    public static void removeExtension(String extensionClassName) {
        for (LayoutDataManagerDescriptor extension : LayoutDataManagerRegistry.getRegisteredExtensions()) {
            if (!extension.getExtensionClassName().equals(extensionClassName)) continue;
            EXTENSIONS.remove(extension);
        }
    }

    public static LayoutDataManagerDescriptor getRegisteredExtension(String id) {
        for (LayoutDataManagerDescriptor desc : EXTENSIONS.keySet()) {
            if (StringUtil.isEmpty((String)desc.getId()) || !desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }

    public static List<SiriusLayoutDataManager> getSiriusLayoutDataManagers(DDiagram diagram) {
        ArrayList<SiriusLayoutDataManager> applicableManagers = new ArrayList<SiriusLayoutDataManager>();
        for (LayoutDataManagerDescriptor descriptor : LayoutDataManagerRegistry.getRegisteredExtensions()) {
            ILayoutDataManagerProvider provider = descriptor.getLayoutDataManagerProvider();
            if (provider == null || !provider.provides(diagram)) continue;
            SiriusLayoutDataManager layoutDataManager = EXTENSIONS.get(descriptor);
            if (layoutDataManager == null) {
                layoutDataManager = provider.getLayoutDataManager();
                EXTENSIONS.put(descriptor, layoutDataManager);
            }
            applicableManagers.add(layoutDataManager);
        }
        applicableManagers.add(SiriusLayoutDataManagerForSemanticElementsFactory.getInstance().getSiriusLayoutDataManager());
        return applicableManagers;
    }

    public static List<SiriusLayoutDataManager> getAllSiriusLayoutDataManagers() {
        ArrayList<SiriusLayoutDataManager> applicableManagers = new ArrayList<SiriusLayoutDataManager>();
        for (LayoutDataManagerDescriptor descriptor : LayoutDataManagerRegistry.getRegisteredExtensions()) {
            ILayoutDataManagerProvider provider = descriptor.getLayoutDataManagerProvider();
            if (provider == null) continue;
            SiriusLayoutDataManager layoutDataManager = EXTENSIONS.get(descriptor);
            if (layoutDataManager == null) {
                layoutDataManager = provider.getLayoutDataManager();
                EXTENSIONS.put(descriptor, layoutDataManager);
            }
            applicableManagers.add(layoutDataManager);
        }
        applicableManagers.add(SiriusLayoutDataManagerForSemanticElementsFactory.getInstance().getSiriusLayoutDataManager());
        return applicableManagers;
    }
}

