/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.util.HashSet;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.client.Session;

public class PruneFolderVisitor
implements ICVSResourceVisitor {
    private ICVSFolder localRoot;

    public void visit(Session s, ICVSResource[] resources) throws CVSException {
        this.visit(s.getLocalRoot(), resources);
    }

    public void visit(ICVSFolder root, ICVSResource[] resources) throws CVSException {
        this.localRoot = root;
        HashSet<ICVSFolder> prunableParents = new HashSet<ICVSFolder>();
        int i = 0;
        while (i < resources.length) {
            ICVSResource cvsResource = resources[i];
            cvsResource.accept(this);
            if (!cvsResource.exists()) {
                prunableParents.add(cvsResource.getParent());
            }
            ++i;
        }
        for (ICVSFolder cvsFolder : prunableParents) {
            this.pruneFolderAndParentsIfAppropriate(cvsFolder);
        }
    }

    @Override
    public void visitFile(ICVSFile file) throws CVSException {
    }

    @Override
    public void visitFolder(ICVSFolder folder) throws CVSException {
        folder.acceptChildren(this);
        this.pruneFolderIfAppropriate(folder);
    }

    private void pruneFolderIfAppropriate(ICVSFolder folder) throws CVSException {
        if (folder.exists() && folder.isManaged() && !folder.equals(this.getLocalRoot()) && folder.members(63).length == 0) {
            folder.delete();
        }
    }

    private ICVSFolder getLocalRoot() {
        return this.localRoot;
    }

    private void pruneFolderAndParentsIfAppropriate(ICVSFolder folder) throws CVSException {
        this.pruneFolderIfAppropriate(folder);
        if (!folder.exists()) {
            ICVSFolder parent = folder.getParent();
            this.pruneFolderAndParentsIfAppropriate(parent);
        }
    }
}

