/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureProcessor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.refactoring.ChangeExceptionsControl;
import org.eclipse.jdt.internal.ui.refactoring.ChangeParametersControl;
import org.eclipse.jdt.internal.ui.refactoring.DelegateUIHelper;
import org.eclipse.jdt.internal.ui.refactoring.IExceptionListChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.InputPageUtil;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ChangeSignatureWizard
extends RefactoringWizard {
    private final ChangeSignatureProcessor fProcessor;

    public ChangeSignatureWizard(ChangeSignatureProcessor processor, Refactoring refactoring) {
        super(refactoring, 4);
        this.fProcessor = processor;
        this.setDefaultPageTitle(RefactoringMessages.ChangeSignatureRefactoring_modify_Parameters);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new ChangeSignatureInputPage(this.fProcessor));
    }

    private static class ChangeSignatureInputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "ChangeSignatureInputPage";
        private JavaSourceViewer fSignaturePreview;
        private Button fLeaveDelegateCheckBox;
        private Button fDeprecateDelegateCheckBox;
        private final ChangeSignatureProcessor fProcessor;

        public ChangeSignatureInputPage(ChangeSignatureProcessor processor) {
            super(PAGE_NAME);
            this.fProcessor = processor;
            this.setMessage(RefactoringMessages.ChangeSignatureInputPage_change);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            this.initializeDialogUnits((Control)composite);
            try {
                this.createHeadControls(composite);
                this.createParameterExceptionsFolder(composite);
                this.fLeaveDelegateCheckBox = DelegateUIHelper.generateLeaveDelegateCheckbox(composite, this.getRefactoring(), false);
                if (this.fLeaveDelegateCheckBox != null) {
                    this.fDeprecateDelegateCheckBox = new Button(composite, 32);
                    GridData data = new GridData();
                    data.horizontalAlignment = 4;
                    data.horizontalIndent = layout.marginWidth + this.fDeprecateDelegateCheckBox.computeSize((int)-1, (int)-1).x;
                    data.horizontalSpan = 2;
                    this.fDeprecateDelegateCheckBox.setLayoutData((Object)data);
                    this.fDeprecateDelegateCheckBox.setText(DelegateUIHelper.getDeprecateDelegateCheckBoxTitle());
                    final ChangeSignatureProcessor processor = this.getChangeMethodSignatureProcessor();
                    this.fDeprecateDelegateCheckBox.setSelection(DelegateUIHelper.loadDeprecateDelegateSetting(processor));
                    processor.setDeprecateDelegates(this.fDeprecateDelegateCheckBox.getSelection());
                    this.fDeprecateDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            processor.setDeprecateDelegates(fDeprecateDelegateCheckBox.getSelection());
                        }
                    });
                    this.fDeprecateDelegateCheckBox.setEnabled(this.fLeaveDelegateCheckBox.getSelection());
                    this.fLeaveDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            fDeprecateDelegateCheckBox.setEnabled(fLeaveDelegateCheckBox.getSelection());
                        }
                    });
                }
                Label sep = new Label(composite, 258);
                sep.setLayoutData((Object)new GridData(768));
                this.createSignaturePreview(composite);
                this.update(false);
                this.setControl((Control)composite);
                Dialog.applyDialogFont((Control)composite);
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.ChangeSignatureInputPage_Change_Signature, RefactoringMessages.ChangeSignatureInputPage_Internal_Error);
            }
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.modify_parameters_wizard_page_context");
        }

        private void createHeadControls(Composite parent) throws JavaModelException {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            this.createAccessControl(composite);
            this.createReturnTypeControl(composite);
            this.createNameControl(composite);
        }

        private void createAccessControl(Composite parent) throws JavaModelException {
            Composite access = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            access.setLayout((Layout)layout);
            final int[] availableVisibilities = this.getChangeMethodSignatureProcessor().getAvailableVisibilities();
            int currentVisibility = this.getChangeMethodSignatureProcessor().getVisibility();
            Label label = new Label(access, 0);
            label.setText(RefactoringMessages.ChangeSignatureInputPage_access_modifier);
            final Combo combo = new Combo(access, 12);
            if (availableVisibilities.length == 0) {
                combo.setEnabled(false);
            } else {
                int i = 0;
                while (i < availableVisibilities.length) {
                    combo.add(this.getAccessModifierString(availableVisibilities[i]));
                    ++i;
                }
                combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int newVisibility = availableVisibilities[combo.getSelectionIndex()];
                        this.getChangeMethodSignatureProcessor().setVisibility(newVisibility);
                        this.update(true);
                    }
                });
            }
            combo.setText(this.getAccessModifierString(currentVisibility));
            combo.setLayoutData((Object)new GridData(256));
            Dialog.applyDialogFont((Control)access);
            access.pack();
            int minLabelWidth = label.getSize().x + 3 * layout.horizontalSpacing;
            if (minLabelWidth > combo.getSize().x) {
                label.setLayoutData((Object)new GridData(minLabelWidth, label.getSize().y));
            }
        }

        private String getAccessModifierString(int modifier) {
            switch (modifier) {
                case 1: {
                    return "public";
                }
                case 4: {
                    return "protected";
                }
                case 0: {
                    return RefactoringMessages.ChangeSignatureInputPage_default;
                }
                case 2: {
                    return "private";
                }
            }
            throw new IllegalArgumentException("\"" + modifier + "\" is not a Modifier constant");
        }

        private void createReturnTypeControl(Composite parent) {
            Composite returnType = new Composite(parent, 0);
            returnType.setLayoutData((Object)new GridData(1808));
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            returnType.setLayout((Layout)layout);
            Label label = new Label(returnType, 0);
            label.setText(RefactoringMessages.ChangeSignatureInputPage_return_type);
            final Text text = new Text(returnType, 2048);
            text.setText(this.getChangeMethodSignatureProcessor().getReturnTypeString());
            text.setLayoutData((Object)new GridData(768));
            TextFieldNavigationHandler.install(text);
            if (this.getChangeMethodSignatureProcessor().canChangeNameAndReturnType()) {
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        this.getChangeMethodSignatureProcessor().setNewReturnTypeName(text.getText());
                        this.update(true);
                    }
                });
            } else {
                text.setEnabled(false);
            }
            JavaTypeCompletionProcessor processor = new JavaTypeCompletionProcessor(true, true);
            StubTypeContext stubTypeContext = this.getChangeMethodSignatureProcessor().getStubTypeContext();
            processor.setCompletionContext(stubTypeContext.getCuHandle(), stubTypeContext.getBeforeString(), stubTypeContext.getAfterString());
            ControlContentAssistHelper.createTextContentAssistant(text, processor);
        }

        private void createNameControl(Composite parent) {
            Composite name = new Composite(parent, 0);
            name.setLayoutData((Object)new GridData(1808));
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            name.setLayout((Layout)layout);
            Label label = new Label(name, 0);
            label.setText(RefactoringMessages.ChangeSignatureInputPage_method_name);
            final Text text = new Text(name, 2048);
            text.setText(this.getChangeMethodSignatureProcessor().getMethodName());
            text.setLayoutData((Object)new GridData(768));
            TextFieldNavigationHandler.install(text);
            if (this.getChangeMethodSignatureProcessor().canChangeNameAndReturnType()) {
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        this.getChangeMethodSignatureProcessor().setNewMethodName(text.getText());
                        this.update(true);
                    }
                });
            } else {
                text.setEnabled(false);
            }
        }

        private void createParameterExceptionsFolder(Composite composite) {
            TabFolder folder = new TabFolder(composite, 128);
            folder.setLayoutData((Object)new GridData(1808));
            TabItem item = new TabItem(folder, 0);
            item.setText(RefactoringMessages.ChangeSignatureInputPage_parameters);
            item.setControl(this.createParameterTableControl((Composite)folder));
            TabItem itemEx = new TabItem(folder, 0);
            itemEx.setText(RefactoringMessages.ChangeSignatureInputPage_exceptions);
            itemEx.setControl(this.createExceptionsTableControl((Composite)folder));
            folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((TabItem)e.item).getControl().setFocus();
                }
            });
        }

        private Control createParameterTableControl(Composite composite) {
            Composite border = new Composite(composite, 0);
            border.setLayout((Layout)new GridLayout());
            String labelText = null;
            ChangeParametersControl cp = new ChangeParametersControl(border, 0, labelText, new IParameterListChangeListener(){

                @Override
                public void parameterChanged(ParameterInfo parameter) {
                    this.update(true);
                }

                @Override
                public void parameterListChanged() {
                    this.update(true);
                }

                @Override
                public void parameterAdded(ParameterInfo parameter) {
                    this.update(true);
                }
            }, ChangeParametersControl.Mode.CHANGE_METHOD_SIGNATURE, this.getChangeMethodSignatureProcessor().getStubTypeContext());
            cp.setLayoutData(new GridData(1808));
            cp.setInput(this.getChangeMethodSignatureProcessor().getParameterInfos());
            return border;
        }

        private Control createExceptionsTableControl(Composite parent) {
            Composite border = new Composite(parent, 0);
            border.setLayout((Layout)new GridLayout());
            ChangeExceptionsControl cp = new ChangeExceptionsControl(border, 0, new IExceptionListChangeListener(){

                @Override
                public void exceptionListChanged() {
                    this.update(true);
                }
            }, this.getChangeMethodSignatureProcessor().getMethod().getJavaProject());
            cp.setLayoutData(new GridData(1808));
            cp.setInput(this.getChangeMethodSignatureProcessor().getExceptionInfos());
            return border;
        }

        public void dispose() {
            DelegateUIHelper.saveLeaveDelegateSetting(this.fLeaveDelegateCheckBox);
            DelegateUIHelper.saveDeprecateDelegateSetting(this.fDeprecateDelegateCheckBox);
            super.dispose();
        }

        private void createSignaturePreview(Composite composite) {
            Label previewLabel = new Label(composite, 0);
            previewLabel.setText(RefactoringMessages.ChangeSignatureInputPage_method_Signature_Preview);
            this.fSignaturePreview = InputPageUtil.createSignaturePreview(composite);
        }

        private ChangeSignatureProcessor getChangeMethodSignatureProcessor() {
            return this.fProcessor;
        }

        private void update(boolean displayErrorMessage) {
            this.updateStatus(displayErrorMessage);
            this.updateSignaturePreview();
        }

        private void updateStatus(boolean displayErrorMessage) {
            try {
                if (this.getChangeMethodSignatureProcessor().isSignatureSameAsInitial()) {
                    if (displayErrorMessage) {
                        this.setErrorMessage(RefactoringMessages.ChangeSignatureInputPage_unchanged);
                    } else {
                        this.setErrorMessage(null);
                    }
                    this.setPageComplete(false);
                    return;
                }
                RefactoringStatus nameCheck = this.getChangeMethodSignatureProcessor().checkSignature();
                if (displayErrorMessage) {
                    this.setPageComplete(nameCheck);
                } else {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                }
            }
            catch (JavaModelException e) {
                this.setErrorMessage(RefactoringMessages.ChangeSignatureInputPage_Internal_Error);
                this.setPageComplete(false);
                JavaPlugin.log(e);
            }
        }

        private void updateSignaturePreview() {
            try {
                int top = this.fSignaturePreview.getTextWidget().getTopPixel();
                this.fSignaturePreview.getDocument().set(this.getChangeMethodSignatureProcessor().getNewMethodSignature());
                this.fSignaturePreview.getTextWidget().setTopPixel(top);
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.ChangeSignatureRefactoring_modify_Parameters, RefactoringMessages.ChangeSignatureInputPage_exception);
            }
        }
    }
}

