/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;

class AssertNotEquals {
    private AssertNotEquals() {
    }

    static void assertNotEquals(Object unexpected, Object actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual, () -> null);
    }

    static void assertNotEquals(Object unexpected, Object actual, String message) {
        AssertNotEquals.assertNotEquals(unexpected, actual, () -> message);
    }

    static void assertNotEquals(Object unexpected, Object actual, Supplier<String> messageSupplier) {
        if (AssertionUtils.objectsAreEqual(unexpected, actual)) {
            AssertNotEquals.failEqual(actual, AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    private static void failEqual(Object actual, String message) {
        AssertionUtils.fail(AssertionUtils.buildPrefix(message) + "expected: not equal but was: <" + actual + ">");
    }
}

