/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.internal.ccvs.core.CVSRepositoryLocationMatcher;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;

public class ConfigureRepositoryLocationsTable
implements ICellModifier,
IStructuredContentProvider,
ITableLabelProvider {
    protected static final String ITEM = "item";
    protected static final String PROPERTY_ALTERNATIVE_LIST = "alternativeList";
    private TableViewer fTableViewer;
    private CellEditor[] cellEditors;
    private TextCellEditor dummyAlternativeRepositoryEditor;
    private Table table;
    private List fAlternatives = new ArrayList();
    private boolean fShowOnlyCompatibeLocations = true;

    public ConfigureRepositoryLocationsTable(Map alternativesMap) {
        for (Map.Entry entry : alternativesMap.entrySet()) {
            this.fAlternatives.add(new RepositoryLocationItem((ICVSRepositoryLocation)entry.getKey(), (List)entry.getValue()));
        }
    }

    public Composite createControl(final Composite composite) {
        this.table = new Table(composite, 68098);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = event.gc.getFontMetrics().getHeight() + 5;
            }
        });
        final TableColumn projectSetRepositoryColumn = new TableColumn(this.table, 0, 0);
        projectSetRepositoryColumn.setText(CVSUIMessages.ConfigureRepositoryLocationsWizard_column0);
        final TableColumn alternativeRepositoryColums = new TableColumn(this.table, 0, 1);
        alternativeRepositoryColums.setText(CVSUIMessages.ConfigureRepositoryLocationsWizard_column1);
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = composite.getClientArea();
                Point size = ConfigureRepositoryLocationsTable.this.table.computeSize(-1, -1);
                ScrollBar vBar = ConfigureRepositoryLocationsTable.this.table.getVerticalBar();
                int width = area.width - ((ConfigureRepositoryLocationsTable)ConfigureRepositoryLocationsTable.this).table.computeTrim((int)0, (int)0, (int)0, (int)0).width - vBar.getSize().x;
                if (size.y > area.height + ConfigureRepositoryLocationsTable.this.table.getHeaderHeight()) {
                    Point vBarSize = vBar.getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = ConfigureRepositoryLocationsTable.this.table.getSize();
                if (oldSize.x > area.width) {
                    projectSetRepositoryColumn.setWidth(width / 2);
                    alternativeRepositoryColums.setWidth(width - projectSetRepositoryColumn.getWidth());
                    ConfigureRepositoryLocationsTable.this.table.setSize(area.width, area.height);
                } else {
                    ConfigureRepositoryLocationsTable.this.table.setSize(area.width, area.height);
                    projectSetRepositoryColumn.setWidth(width / 2);
                    alternativeRepositoryColums.setWidth(width - projectSetRepositoryColumn.getWidth());
                }
            }
        });
        this.fTableViewer = new TableViewer(this.table);
        this.fTableViewer.setContentProvider((IContentProvider)this);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this);
        this.fTableViewer.setComparator((ViewerComparator)new AlternativeRepositoryComparator());
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.fTableViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.fTableViewer));
        ColumnViewerEditorActivationStrategy editorActivationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.fTableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 3 || event.eventType == 1 && event.keyCode == 0x100000B;
            }
        };
        TableViewerEditor.create((TableViewer)this.fTableViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)editorActivationStrategy, (int)33);
        this.cellEditors = new CellEditor[2];
        this.cellEditors[0] = null;
        this.dummyAlternativeRepositoryEditor = new TextCellEditor((Composite)this.table, 8);
        this.cellEditors[1] = this.dummyAlternativeRepositoryEditor;
        this.fTableViewer.setCellEditors(this.cellEditors);
        this.fTableViewer.setColumnProperties(new String[]{ITEM, PROPERTY_ALTERNATIVE_LIST});
        this.fTableViewer.setCellModifier((ICellModifier)this);
        this.fTableViewer.setInput((Object)this.fAlternatives);
        int i = 0;
        while (i < this.fTableViewer.getTable().getItemCount()) {
            Object element = this.fTableViewer.getElementAt(i);
            RepositoryLocationItem locationItem = (RepositoryLocationItem)element;
            if (locationItem.alternativeList.size() > 1 && !KnownRepositories.getInstance().isKnownRepository(((ICVSRepositoryLocation)locationItem.alternativeList.get(0)).getLocation(false)) && CVSRepositoryLocationMatcher.isCompatible((ICVSRepositoryLocation)locationItem.location, (ICVSRepositoryLocation)((ICVSRepositoryLocation)locationItem.alternativeList.get(1)), (boolean)false)) {
                locationItem.selected = 1;
            }
            ++i;
        }
        this.fTableViewer.refresh();
        return this.table;
    }

    public Object getValue(Object element, String property) {
        Item item = (Item)element;
        if (PROPERTY_ALTERNATIVE_LIST.equals(property)) {
            return new Integer(item.selected);
        }
        return null;
    }

    public boolean canModify(Object element, String property) {
        this.cellEditors[1] = this.getCellEditor(element);
        return PROPERTY_ALTERNATIVE_LIST.equals(property);
    }

    private CellEditor getCellEditor(Object element) {
        if (element instanceof RepositoryLocationItem) {
            RepositoryLocationItem item = (RepositoryLocationItem)element;
            return new ComboBoxCellEditor((Composite)this.table, this.getFilteredAlternativeRepositoriesForDisplay(item), 8);
        }
        return this.dummyAlternativeRepositoryEditor;
    }

    public void modify(Object element, String property, Object value) {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Item item = (Item)selection.getFirstElement();
        if (item == null) {
            return;
        }
        int comboIndex = (Integer)value;
        if (PROPERTY_ALTERNATIVE_LIST.equals(property)) {
            item.selected = comboIndex;
        }
        this.fTableViewer.refresh((Object)item);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Item item = (Item)element;
        switch (columnIndex) {
            case 0: {
                return item.location.getLocation(false);
            }
            case 1: {
                return this.getFilteredAlternativeRepositoriesForDisplay(item)[item.selected];
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Object[] getElements(Object inputElement) {
        return ((Collection)inputElement).toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    public TableViewer getViewer() {
        return this.fTableViewer;
    }

    public CVSRepositoryLocation getSelectedAlternativeRepository() {
        RepositoryLocationItem firstElement = (RepositoryLocationItem)this.getSelection().getFirstElement();
        return (CVSRepositoryLocation)this.getFilteredAlternativeRepositories(firstElement).get(firstElement.selected);
    }

    void addAlternativeRepository(ICVSRepositoryLocation location) {
        int i = 0;
        while (i < this.fTableViewer.getTable().getItemCount()) {
            Object element = this.fTableViewer.getElementAt(i);
            RepositoryLocationItem rli = (RepositoryLocationItem)element;
            rli.alternativeList.add(location);
            if (this.getSelection().toList().contains(element) && CVSRepositoryLocationMatcher.isCompatible((ICVSRepositoryLocation)location, (ICVSRepositoryLocation)rli.location, (boolean)false)) {
                rli.selected = this.getFilteredAlternativeRepositories(rli).size() - 1;
            }
            ++i;
        }
        this.fTableViewer.refresh(true);
    }

    public Map getSelected() {
        HashMap map = new HashMap();
        for (RepositoryLocationItem rli : this.fAlternatives) {
            map.put(rli.location, this.getFilteredAlternativeRepositories(rli).get(rli.selected));
        }
        return map;
    }

    public void setShowOnlyCompatibleLocations(boolean show) {
        this.fShowOnlyCompatibeLocations = show;
        int i = 0;
        while (i < this.fTableViewer.getTable().getItemCount()) {
            Object element = this.fTableViewer.getElementAt(i);
            RepositoryLocationItem rli = (RepositoryLocationItem)element;
            this.updateSelection(rli);
            ++i;
        }
        this.fTableViewer.refresh(true);
    }

    private List getFilteredAlternativeRepositories(Item item) {
        return this.getFilteredAlternativeRepositories(item, this.fShowOnlyCompatibeLocations);
    }

    private List getFilteredAlternativeRepositories(Item item, boolean showOnlyCompatible) {
        List alternativeList = item.alternativeList;
        if (!showOnlyCompatible) {
            return alternativeList;
        }
        ArrayList<CVSRepositoryLocation> alternativeFiltered = new ArrayList<CVSRepositoryLocation>();
        int i = 0;
        while (i < alternativeList.size()) {
            CVSRepositoryLocation repo = (CVSRepositoryLocation)alternativeList.get(i);
            if (CVSRepositoryLocationMatcher.isCompatible((ICVSRepositoryLocation)item.location, (ICVSRepositoryLocation)repo, (boolean)true)) {
                alternativeFiltered.add(repo);
            }
            ++i;
        }
        return alternativeFiltered;
    }

    private void updateSelection(Item item) {
        if (this.fShowOnlyCompatibeLocations) {
            int shift = 0;
            int j = 0;
            while (j <= item.selected) {
                ICVSRepositoryLocation rl = (ICVSRepositoryLocation)item.alternativeList.get(j);
                if (!CVSRepositoryLocationMatcher.isCompatible((ICVSRepositoryLocation)item.location, (ICVSRepositoryLocation)rl, (boolean)true)) {
                    ++shift;
                }
                ++j;
            }
            item.selected -= shift;
            ICVSRepositoryLocation selected = (ICVSRepositoryLocation)this.getFilteredAlternativeRepositories(item).get(item.selected);
            if (!CVSRepositoryLocationMatcher.isCompatible((ICVSRepositoryLocation)item.location, (ICVSRepositoryLocation)selected, (boolean)true)) {
                item.selected = 0;
                int j2 = 0;
                while (j2 < item.alternativeList.size()) {
                    ICVSRepositoryLocation l = (ICVSRepositoryLocation)item.alternativeList.get(j2);
                    if (CVSRepositoryLocationMatcher.isCompatible((ICVSRepositoryLocation)l, (ICVSRepositoryLocation)item.location, (boolean)true)) {
                        item.selected = j2;
                        break;
                    }
                    ++j2;
                }
            }
        } else {
            int shift = 0;
            int j = 0;
            while (j <= this.getFilteredAlternativeRepositories(item).indexOf(this.getFilteredAlternativeRepositories(item, true).get(item.selected))) {
                ICVSRepositoryLocation rl = (ICVSRepositoryLocation)item.alternativeList.get(j);
                if (!CVSRepositoryLocationMatcher.isCompatible((ICVSRepositoryLocation)item.location, (ICVSRepositoryLocation)rl, (boolean)true)) {
                    ++shift;
                }
                ++j;
            }
            item.selected += shift;
        }
    }

    private String[] getFilteredAlternativeRepositoriesForDisplay(Item item) {
        List filteredAlternativeList = this.getFilteredAlternativeRepositories(item);
        ArrayList<String> repositoriesForDisplay = new ArrayList<String>();
        int i = 0;
        while (i < filteredAlternativeList.size()) {
            CVSRepositoryLocation rl = (CVSRepositoryLocation)filteredAlternativeList.get(i);
            repositoriesForDisplay.add(rl.getLocation());
            ++i;
        }
        return repositoriesForDisplay.toArray(new String[0]);
    }

    private static final class AlternativeRepositoryComparator
    extends ViewerComparator {
        private int getCategory(Object element) {
            if (element instanceof RepositoryLocationItem) {
                return 0;
            }
            return 2;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int compare = this.getCategory(e1) - this.getCategory(e2);
            if (compare != 0) {
                return compare;
            }
            return super.compare(viewer, (Object)((Item)e1).location, (Object)((Item)e2).location);
        }
    }

    public static abstract class Item
    implements Comparable {
        public final ICVSRepositoryLocation location;
        public List alternativeList;
        public int selected;

        public Item(ICVSRepositoryLocation name, List alternative) {
            this.location = name;
            this.alternativeList = alternative;
            this.selected = 0;
        }

        public int compareTo(Object o) {
            return this.location.getLocation(false).compareTo(((Item)o).location.getLocation(false));
        }
    }

    public static class RepositoryLocationItem
    extends Item {
        public RepositoryLocationItem(ICVSRepositoryLocation projectSetRepositoryLocation, List suggestedRepositoryLocations) {
            super(projectSetRepositoryLocation, suggestedRepositoryLocations);
        }
    }
}

