/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.editor.pages;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.actions.DescriptionAction;
import org.eclipse.amalgam.explorer.activity.ui.api.actions.OpenActivityExplorerAction2;
import org.eclipse.amalgam.explorer.activity.ui.api.actions.ViewerFilteringAction;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.activities.ExplorerActivity;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.ActivityExplorerPage;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.FormHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.viewers.AbstractActivityExplorerViewer;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.viewers.DiagramViewer;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.sections.ActivityExplorerSection;
import org.eclipse.amalgam.explorer.activity.ui.api.hyperlinkadapter.AbstractNewDiagramHyperlinkAdapter;
import org.eclipse.amalgam.explorer.activity.ui.internal.actions.util.MDSashForm;
import org.eclipse.amalgam.explorer.activity.ui.internal.extension.point.manager.ActivityExplorerExtensionManager;
import org.eclipse.amalgam.explorer.activity.ui.internal.util.ActivityExplorerLoggerService;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class BasicSessionActivityExplorerPage
extends ActivityExplorerPage {
    private static final int DIAGRAMS_VIEWER_WEIGHT = 40;
    private static final int SECTION_WEIGHT = 60;
    private Composite _viewerContainer;
    private Set<AbstractActivityExplorerViewer> viewers = new HashSet<AbstractActivityExplorerViewer>();
    private boolean displayViewer;

    @Override
    protected void createHeaderSections(Composite sectionContainer_p, IManagedForm managedForm_p) {
        final Form formWidget = managedForm_p.getForm().getForm();
        formWidget.getMenuManager().add((IContributionItem)new Separator("empty-list"));
        formWidget.getMenuManager().addMenuListener((IMenuListener)new IMenuListener2(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.removeAll();
                for (Session session : SessionManager.INSTANCE.getSessions()) {
                    if (session.equals(BasicSessionActivityExplorerPage.this.getEditorInput().getSession())) continue;
                    formWidget.getMenuManager().add((IAction)new OpenActivityExplorerAction2(session));
                }
            }

            public void menuAboutToHide(IMenuManager manager) {
            }
        });
        formWidget.getToolBarManager().update(true);
        this.createOverviewSection(sectionContainer_p, managedForm_p);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm_p) {
        super.createFormContent(managedForm_p);
        if (this.displayViewer) {
            MDSashForm sashForm = (MDSashForm)this.getSectionContainer().getParent();
            this._viewerContainer = this.createViewerContainer((Composite)sashForm, managedForm_p);
            this._viewerContainer.setLayoutData((Object)new GridData(1808));
            this.createViewers(this._viewerContainer, managedForm_p);
            this.hookResizeListener();
            sashForm.setWeights(new int[]{60, 40});
            managedForm_p.reflow(true);
        }
    }

    protected Class<? extends AbstractActivityExplorerViewer>[] addViewersTypeInPage() {
        return new Class[]{DiagramViewer.class};
    }

    private void createViewers(Composite viewerContainer_p, IManagedForm managedForm_p) {
        Class<? extends AbstractActivityExplorerViewer>[] viewerTab;
        Class<? extends AbstractActivityExplorerViewer>[] classArray = viewerTab = this.addViewersTypeInPage();
        int n = viewerTab.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends AbstractActivityExplorerViewer> viewer = classArray[n2];
            AbstractActivityExplorerViewer newViewer = this.addNewViewer(viewer);
            newViewer.createViewer(viewerContainer_p, managedForm_p);
            ++n2;
        }
    }

    protected final AbstractActivityExplorerViewer addNewViewer(Class<? extends AbstractActivityExplorerViewer> viewer) {
        AbstractActivityExplorerViewer newViewer = null;
        try {
            newViewer = viewer.getConstructor(BasicSessionActivityExplorerPage.class).newInstance(this);
            this.viewers.add(newViewer);
        }
        catch (Exception ex) {
            ActivityExplorerLoggerService.getInstance().log(4, ex.toString(), ex);
        }
        return newViewer;
    }

    protected Composite createViewerContainer(Composite parent_p, IManagedForm managedForm_p) {
        return FormHelper.createCompositeWithLayoutType(managedForm_p.getToolkit(), parent_p, FormHelper.LayoutType.GRID_LAYOUT, 1, true);
    }

    @Override
    public void dispose() {
        ActivityExplorerActivator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        for (AbstractActivityExplorerViewer viewer : this.viewers) {
            viewer.dispose();
        }
        this.viewers.clear();
        super.dispose();
    }

    public Set<String> getHandledViewpoint() {
        HashSet<String> vps = new HashSet<String>();
        for (ActivityExplorerSection section : this.getSections()) {
            for (ExplorerActivity activity : section.getActivities()) {
                IHyperlinkListener listener = activity.getListener();
                if (!(listener instanceof AbstractNewDiagramHyperlinkAdapter)) continue;
                try {
                    vps.add(((AbstractNewDiagramHyperlinkAdapter)listener).getRepresentationName());
                }
                catch (Throwable e) {
                    StringBuilder message = new StringBuilder();
                    message.append("BasicSessionActivityExplorerPage.getHandledViewpoint() _ ");
                    message.append("Could not retrieve a representation name from contribution. See the error stack for more details.");
                    ActivityExplorerLoggerService.getInstance().log(4, message.toString(), e);
                }
            }
        }
        return vps;
    }

    @Override
    protected void handleContributedSectionsFor(IConfigurationElement contributor_p) {
        ActivityExplorerSection newSection = new ActivityExplorerSection(contributor_p){

            @Override
            protected IAction[] getToolBarActions() {
                IAction[] toolbarActions = new IAction[]{new DescriptionAction(BasicSessionActivityExplorerPage.this.getSite().getShell(), this.getDescription()), new ViewerFilteringAction(BasicSessionActivityExplorerPage.this, this)};
                if (!this.isFiltering()) {
                    toolbarActions = new IAction[]{new DescriptionAction(BasicSessionActivityExplorerPage.this.getSite().getShell(), this.getDescription())};
                }
                return toolbarActions;
            }
        };
        boolean value = this.getSections().add(newSection);
        if (!value) {
            StringBuilder message = new StringBuilder();
            message.append("The declared section: ");
            message.append(newSection.getId());
            message.append(" has the same index of a another section. Changes it!");
            ActivityExplorerLoggerService.getInstance().log(4, message.toString(), null);
        }
    }

    @Override
    public void setActive(boolean active_p) {
        super.setActive(active_p);
        if (active_p) {
            this.setCurrentPageSelectionToPropertySheetPage();
        }
    }

    protected void setCurrentPageSelectionToPropertySheetPage() {
        TabbedPropertySheetPage propertySheetPage = this.getEditor().getPropertySheetPage();
        if (propertySheetPage != null) {
            // empty if block
        }
    }

    public void callViewersFilter(ViewerFilteringAction action_p) {
        for (AbstractActivityExplorerViewer viewer : this.viewers) {
            viewer.setViewerFilter(action_p);
        }
    }

    @Override
    public void updateActionBars() {
        IActionBars editorActionBars = this.getEditorSite().getActionBars();
        editorActionBars.updateActionBars();
    }

    protected boolean isDisplayViewerInPage() {
        return this.displayViewer;
    }

    @Override
    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        super.setInitializationData(cfig, propertyName, data);
        this.displayViewer = ActivityExplorerExtensionManager.getIsDisplayViewerInPage(cfig);
    }

    @Override
    public boolean isVisible() {
        boolean result = super.isVisible();
        return result &= !this.getVisibleSections().isEmpty();
    }
}

