/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.desc;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReuse;
import org.polarsys.kitalpha.resourcereuse.model.Location;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;

public class ViewpointModelReuseResourceHelper {
    private static final String VPDSL_MODELREUSE_DOMAIN_ = "vpdsl";
    private static final String VPDSL_MODELREUSE_TAG_ = "vpdesc";

    public static List<Viewpoint> getAvailableVpdslViewpoints(ResourceSet resourceSet) {
        ArrayList<Viewpoint> result = new ArrayList<Viewpoint>();
        Resource[] resourceVpdslList = ViewpointModelReuseResourceHelper.getResources(null, VPDSL_MODELREUSE_DOMAIN_, VPDSL_MODELREUSE_TAG_);
        if (resourceVpdslList.length > 0) {
            Resource[] resourceArray = resourceVpdslList;
            int n = resourceVpdslList.length;
            int n2 = 0;
            while (n2 < n) {
                Resource resource_vpdsl = resourceArray[n2];
                URI uri = ViewpointModelReuseResourceHelper.getResourceURI(resource_vpdsl);
                EObject eObject = ViewpointModelReuseResourceHelper.getResourceRootObject(uri, resourceSet);
                if (eObject != null && eObject instanceof Viewpoint) {
                    result.add((Viewpoint)eObject);
                }
                ++n2;
            }
        }
        return result;
    }

    public static List<Viewpoint> getAllViewpointExceptCurrent(Viewpoint currentViewpoint) {
        List<Viewpoint> availableViewpoint = ViewpointModelReuseResourceHelper.getAvailableVpdslViewpoints(null);
        boolean checkName = currentViewpoint.getName() != null && currentViewpoint.getName().length() > 0;
        boolean checkShortName = currentViewpoint.getShortName() != null && currentViewpoint.getShortName().length() > 0;
        Viewpoint viewpointToRemove = null;
        for (Viewpoint iViewpoint : availableViewpoint) {
            boolean iCheckShortName;
            boolean equals = true;
            boolean iCheckName = iViewpoint.getName() != null && iViewpoint.getName().length() > 0;
            boolean bl = iCheckShortName = iViewpoint.getShortName() != null && iViewpoint.getShortName().length() > 0;
            if (iCheckName && checkName && !iViewpoint.getName().equals(currentViewpoint.getName())) {
                equals = false;
            }
            if (iCheckShortName && checkShortName && !iViewpoint.getShortName().equals(currentViewpoint.getShortName())) {
                equals = false;
            }
            if (!equals) continue;
            viewpointToRemove = iViewpoint;
            break;
        }
        if (viewpointToRemove != null) {
            availableViewpoint.remove(viewpointToRemove);
        }
        return availableViewpoint;
    }

    protected static Resource[] getResources(String id, String domain, String tag) {
        SearchCriteria searchCriteria = new SearchCriteria();
        if (id != null && id.trim().length() > 0) {
            searchCriteria.setId(id);
        }
        searchCriteria.setDomain(domain);
        searchCriteria.getTags().add(tag);
        return ResourceReuse.createHelper().getResources(searchCriteria);
    }

    protected static EObject getResourceRootObject(URI uri, ResourceSet resourceSet) {
        EObject result = null;
        if (resourceSet == null) {
            resourceSet = new ResourceSetImpl();
        }
        if (uri != null) {
            if (uri.fragment() == null) {
                org.eclipse.emf.ecore.resource.Resource resource = resourceSet.getResource(uri, true);
                if (resource != null && resource.getContents() != null && resource.getContents().size() > 0) {
                    result = (EObject)resource.getContents().get(0);
                }
            } else {
                result = resourceSet.getEObject(uri, true);
            }
        }
        return result;
    }

    protected static URI getResourceURI(Resource resourceAf) {
        Location resourceLocation = resourceAf.getProviderLocation();
        URI uri = null;
        String resourcePath = resourceAf.getPath();
        switch (resourceLocation) {
            case WORSPACE: {
                uri = URI.createURI((String)("platform:/resource" + resourcePath), (boolean)false);
                break;
            }
            case PLATFORM: 
            case TARGET: {
                uri = URI.createURI((String)("platform:/plugin" + resourcePath), (boolean)false);
            }
        }
        return uri;
    }
}

