/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.EclipseFile;
import org.eclipse.team.internal.ccvs.core.resources.EclipseFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTreeBuilder;
import org.eclipse.team.internal.ccvs.core.resources.UpdateContentCachingService;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class CVSWorkspaceRoot {
    private ICVSFolder localRoot;

    public CVSWorkspaceRoot(IContainer resource) {
        this.localRoot = CVSWorkspaceRoot.getCVSFolderFor(resource);
    }

    public static void setSharing(IProject project, FolderSyncInfo info, IProgressMonitor monitor) throws TeamException {
        ICVSFolder folder = (ICVSFolder)CVSWorkspaceRoot.getCVSResourceFor((IResource)project);
        FolderSyncInfo folderInfo = folder.getFolderSyncInfo();
        if (!info.equals(folderInfo)) {
            throw new CVSException((IStatus)new CVSStatus(4, NLS.bind((String)CVSMessages.CVSProvider_infoMismatch, (Object[])new String[]{project.getName()})));
        }
        String root = info.getRoot();
        KnownRepositories.getInstance().getRepository(root);
        RepositoryProvider.map((IProject)project, (String)CVSProviderPlugin.getTypeId());
    }

    public static ICVSFolder getCVSFolderFor(IContainer resource) {
        return new EclipseFolder(resource);
    }

    public static ICVSFile getCVSFileFor(IFile resource) {
        return new EclipseFile(resource);
    }

    public static ICVSResource getCVSResourceFor(IResource resource) {
        if (resource.getType() == 1) {
            return CVSWorkspaceRoot.getCVSFileFor((IFile)resource);
        }
        return CVSWorkspaceRoot.getCVSFolderFor((IContainer)resource);
    }

    public static ICVSRemoteResource getRemoteResourceFor(IResource resource) throws CVSException {
        ICVSResource managed = CVSWorkspaceRoot.getCVSResourceFor(resource);
        return CVSWorkspaceRoot.getRemoteResourceFor(managed);
    }

    public static ICVSRemoteResource getRemoteResourceFor(ICVSResource resource) throws CVSException {
        if (resource.isFolder()) {
            ICVSFolder folder = (ICVSFolder)resource;
            FolderSyncInfo syncInfo = folder.getFolderSyncInfo();
            if (syncInfo != null) {
                return new RemoteFolder(null, KnownRepositories.getInstance().getRepository(syncInfo.getRoot()), syncInfo.getRepository(), syncInfo.getTag());
            }
        } else if (resource.isManaged()) {
            RemoteFolder parent = (RemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor(resource.getParent());
            if (parent == null) {
                if (resource.isManaged()) {
                    CVSProviderPlugin.log((IStatus)new CVSStatus(4, 4, NLS.bind((String)CVSMessages.CVSWorkspaceRoot_11, (Object[])new String[]{Util.getFullestPath(resource)}), resource.getIResource()));
                }
            } else {
                return RemoteFile.getBase(parent, (ICVSFile)resource);
            }
        }
        return null;
    }

    private static ICVSRemoteResource getRemoteTreeFromParent(IResource resource, ICVSResource managed, CVSTag tag, IProgressMonitor progress) throws TeamException {
        ICVSFolder parent = managed.getParent();
        FolderSyncInfo syncInfo = parent.getFolderSyncInfo();
        if (syncInfo == null) {
            return null;
        }
        ICVSRepositoryLocation location = KnownRepositories.getInstance().getRepository(parent.getFolderSyncInfo().getRoot());
        RemoteFolderTree remoteParent = RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)location, parent, tag, progress);
        ICVSRemoteResource remote = null;
        if (remoteParent != null) {
            try {
                remote = (ICVSRemoteResource)remoteParent.getChild(resource.getName());
            }
            catch (CVSException cVSException) {
                remote = null;
            }
            if (remote != null && remote.isContainer() != managed.isFolder()) {
                throw new CVSException((IStatus)new CVSStatus(4, 4, NLS.bind((String)CVSMessages.CVSTeamProvider_typesDiffer, (Object[])new String[]{resource.getFullPath().toString()}), resource));
            }
        }
        return remote;
    }

    public static ICVSRemoteResource getRemoteTree(IResource resource, CVSTag tag, boolean cacheFileContentsHint, int depth, IProgressMonitor progress) throws TeamException {
        ICVSResource managed = CVSWorkspaceRoot.getCVSResourceFor(resource);
        ICVSRemoteResource remote = CVSWorkspaceRoot.getRemoteResourceFor(resource);
        if (remote == null) {
            progress.beginTask(null, 100);
            remote = CVSWorkspaceRoot.getRemoteTreeFromParent(resource, managed, tag, Policy.subMonitorFor(progress, 50));
            if (cacheFileContentsHint && remote != null && remote instanceof RemoteFile) {
                RemoteFile file = (RemoteFile)remote;
                file.getStorage(Policy.subMonitorFor(progress, 50));
            }
            progress.done();
        } else if (resource.getType() == 1) {
            ICVSRepositoryLocation location = remote.getRepository();
            remote = cacheFileContentsHint ? UpdateContentCachingService.buildRemoteTree((CVSRepositoryLocation)location, (ICVSFile)managed, tag, progress) : RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)location, (ICVSFile)managed, tag, progress);
        } else {
            ICVSRepositoryLocation location = remote.getRepository();
            remote = cacheFileContentsHint ? UpdateContentCachingService.buildRemoteTree((CVSRepositoryLocation)location, (ICVSFolder)managed, tag, depth, progress) : RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)location, (ICVSFolder)managed, tag, progress);
        }
        return remote;
    }

    public static boolean hasRemote(IResource resource) {
        try {
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor(resource);
            int type = resource.getType();
            if (type != 1) {
                if (type == 4) {
                    return ((ICVSFolder)cvsResource).isCVSFolder();
                }
                return cvsResource.isManaged();
            }
            byte[] syncBytes = ((ICVSFile)cvsResource).getSyncBytes();
            if (syncBytes != null) {
                return !ResourceSyncInfo.isAddition(syncBytes);
            }
            return false;
        }
        catch (CVSException cVSException) {
            return false;
        }
    }

    public ICVSRepositoryLocation getRemoteLocation() throws CVSException {
        FolderSyncInfo info = this.localRoot.getFolderSyncInfo();
        if (info == null) {
            CVSStatus status = new CVSStatus(4, 1, NLS.bind((String)CVSMessages.CVSWorkspaceRoot_notCVSFolder, (Object[])new String[]{this.localRoot.getName()}), this.localRoot);
            throw new CVSException((IStatus)status);
        }
        return KnownRepositories.getInstance().getRepository(info.getRoot());
    }

    public ICVSFolder getLocalRoot() {
        return this.localRoot;
    }

    public static boolean isLinkedResource(IResource resource) {
        return resource.isLinked(512);
    }

    public static boolean isSharedWithCVS(IResource resource) throws CVSException {
        if (!resource.isAccessible()) {
            return false;
        }
        if (CVSWorkspaceRoot.isLinkedResource(resource)) {
            return false;
        }
        if (RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId()) == null) {
            return false;
        }
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor(resource);
        if (cvsResource.isManaged()) {
            return true;
        }
        if (!cvsResource.exists()) {
            return false;
        }
        if (cvsResource.isFolder() && ((ICVSFolder)cvsResource).isCVSFolder()) {
            return true;
        }
        if (cvsResource.isIgnored()) {
            return false;
        }
        return cvsResource.getParent().isCVSFolder();
    }

    public static boolean isOrphanedSubtree(IContainer container) throws CVSException {
        ICVSFolder mFolder = CVSWorkspaceRoot.getCVSFolderFor(container);
        return mFolder.isCVSFolder() && !mFolder.isManaged() && mFolder.getIResource().getType() == 2 && !CVSWorkspaceRoot.isLinkedResource((IResource)container);
    }
}

