/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.TeamStatus;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberChangeEvent;
import org.eclipse.team.core.subscribers.SubscriberResourceMappingContext;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantTree;
import org.eclipse.team.core.variants.PersistantResourceVariantByteStore;
import org.eclipse.team.core.variants.ResourceVariantByteStore;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSSyncTreeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.IResourceStateChangeListener;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.CVSBaseResourceVariantTree;
import org.eclipse.team.internal.ccvs.core.syncinfo.CVSDescendantResourceVariantByteStore;
import org.eclipse.team.internal.ccvs.core.syncinfo.CVSResourceVariantTree;
import org.eclipse.team.internal.ccvs.core.util.ResourceStateChangeListeners;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;

public class CVSWorkspaceSubscriber
extends CVSSyncTreeSubscriber
implements IResourceStateChangeListener {
    private CVSResourceVariantTree baseTree;
    private CVSResourceVariantTree remoteTree;
    private static final String REMOTE_RESOURCE_KEY = "remote-resource-key";
    private boolean contentFetch;

    CVSWorkspaceSubscriber(QualifiedName id, String name) {
        super(id, name);
        CVSBaseResourceVariantTree baseSynchronizer = new CVSBaseResourceVariantTree();
        this.baseTree = new CVSResourceVariantTree(baseSynchronizer, null, this.getCacheFileContentsHint()){

            public IResource[] refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
                try {
                    monitor.beginTask(null, 100);
                    IResource[] iResourceArray = new IResource[]{};
                    return iResourceArray;
                }
                finally {
                    monitor.done();
                }
            }
        };
        CVSDescendantResourceVariantByteStore remoteSynchronizer = new CVSDescendantResourceVariantByteStore(baseSynchronizer, new PersistantResourceVariantByteStore(new QualifiedName("org.eclipse.team.cvs", REMOTE_RESOURCE_KEY)));
        this.remoteTree = new CVSResourceVariantTree((ResourceVariantByteStore)remoteSynchronizer, null, this.getCacheFileContentsHint()){

            @Override
            public boolean isCacheFileContentsHint() {
                return CVSWorkspaceSubscriber.this.getCacheFileContentsHint();
            }
        };
        ResourceStateChangeListeners.getListener().addResourceStateChangeListener(this);
    }

    public IResource[] roots() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            RepositoryProvider provider;
            IProject project = projects[i];
            if (project.isOpen() && (provider = RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId())) != null) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray(new IProject[result.size()]);
    }

    @Override
    public void resourceSyncInfoChanged(IResource[] changedResources) {
        this.internalResourceSyncInfoChanged(changedResources, true);
    }

    private void internalResourceSyncInfoChanged(IResource[] changedResources, boolean canModifyWorkspace) {
        this.getRemoteByteStore().handleResourceChanges(changedResources, canModifyWorkspace);
        this.fireTeamResourceChange((ISubscriberChangeEvent[])SubscriberChangeEvent.asSyncChangedDeltas((Subscriber)this, (IResource[])changedResources));
    }

    @Override
    public void externalSyncInfoChange(IResource[] changedResources) {
        this.internalResourceSyncInfoChanged(changedResources, false);
    }

    @Override
    public void resourceModified(IResource[] changedResources) {
    }

    @Override
    public void projectConfigured(IProject project) {
        SubscriberChangeEvent delta = new SubscriberChangeEvent((Subscriber)this, 2, (IResource)project);
        this.fireTeamResourceChange((ISubscriberChangeEvent[])new SubscriberChangeEvent[]{delta});
    }

    @Override
    public void projectDeconfigured(IProject project) {
        try {
            this.getRemoteTree().flushVariants((IResource)project, 2);
        }
        catch (TeamException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        SubscriberChangeEvent delta = new SubscriberChangeEvent((Subscriber)this, 4, (IResource)project);
        this.fireTeamResourceChange((ISubscriberChangeEvent[])new SubscriberChangeEvent[]{delta});
    }

    public void setRemote(IResource resource, IResourceVariant remote, IProgressMonitor monitor) throws TeamException {
        IResource[] changedResources = ((CVSResourceVariantTree)this.getRemoteTree()).collectChanges(resource, remote, 2, monitor);
        if (changedResources.length != 0) {
            this.fireTeamResourceChange((ISubscriberChangeEvent[])SubscriberChangeEvent.asSyncChangedDeltas((Subscriber)this, (IResource[])changedResources));
        }
    }

    protected IResourceVariantTree getBaseTree() {
        return this.baseTree;
    }

    protected IResourceVariantTree getRemoteTree() {
        return this.remoteTree;
    }

    public void collectOutOfSync(IResource[] resources, int depth, final SyncInfoSet set, final IProgressMonitor monitor) {
        monitor.beginTask(null, -1);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            try {
                if (!this.isSupervised(resource)) {
                    return;
                }
            }
            catch (TeamException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
            }
            try {
                this.visit(resource, new IResourceVisitor(){

                    public boolean visit(IResource innerResource) throws CoreException {
                        try {
                            SyncInfo info;
                            Policy.checkCanceled(monitor);
                            if (innerResource.getType() != 1) {
                                monitor.subTask(NLS.bind((String)CVSMessages.CVSWorkspaceSubscriber_1, (Object[])new String[]{innerResource.getFullPath().toString()}));
                            }
                            if (CVSWorkspaceSubscriber.this.isOutOfSync(innerResource, monitor) && (info = CVSWorkspaceSubscriber.this.getSyncInfo(innerResource)) != null && info.getKind() != 0) {
                                set.add(info);
                            }
                        }
                        catch (TeamException e) {
                            set.addError((ITeamStatus)new TeamStatus(4, "org.eclipse.team.cvs.core", 1, NLS.bind((String)CVSMessages.CVSWorkspaceSubscriber_2, (Object[])new String[]{innerResource.getFullPath().toString(), e.getMessage()}), (Throwable)e, innerResource));
                        }
                        return true;
                    }
                }, depth);
            }
            catch (CoreException e) {
                set.addError((ITeamStatus)new TeamStatus(4, "org.eclipse.team.cvs.core", 2, e.getMessage(), (Throwable)e, (IResource)ResourcesPlugin.getWorkspace().getRoot()));
            }
            ++i;
        }
        monitor.done();
    }

    private void visit(IResource resource, IResourceVisitor visitor, int depth) throws CoreException {
        boolean keepGoing = visitor.visit(resource);
        if (keepGoing && depth != 0) {
            IResource[] members = this.members(resource);
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                this.visit(member, visitor, depth == 1 ? 0 : 2);
                ++i;
            }
        }
    }

    boolean isOutOfSync(IResource resource, IProgressMonitor monitor) throws TeamException {
        return this.hasIncomingChange(resource) || this.hasOutgoingChange(resource, monitor);
    }

    private boolean hasIncomingChange(IResource resource) throws TeamException {
        return this.getRemoteByteStore().isVariantKnown(resource);
    }

    private boolean hasOutgoingChange(IResource resource, IProgressMonitor monitor) throws CVSException {
        if (resource.getType() == 4 || resource.getType() == 8) {
            return false;
        }
        int state = EclipseSynchronizer.getInstance().getModificationState((IResource)resource.getParent());
        if (state == 1) {
            return false;
        }
        if (resource.getType() == 1) {
            ICVSFile file = CVSWorkspaceRoot.getCVSFileFor((IFile)resource);
            return file.isModified(monitor);
        }
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)resource);
        return !folder.isCVSFolder() && !folder.isIgnored();
    }

    private CVSDescendantResourceVariantByteStore getRemoteByteStore() {
        return (CVSDescendantResourceVariantByteStore)((CVSResourceVariantTree)this.getRemoteTree()).getByteStore();
    }

    public void updateRemote(CVSTeamProvider provider, ICVSFolder folder, boolean recurse, IProgressMonitor monitor) throws TeamException {
        try {
            monitor.beginTask(null, -1);
            IResource resource = folder.getIResource();
            if (resource != null) {
                ICVSRemoteResource tree = this.buildBaseTree(resource, false, Policy.subMonitorFor(monitor, 50));
                this.setRemote(resource, (IResourceVariant)tree, Policy.subMonitorFor(monitor, 50));
            }
        }
        finally {
            monitor.done();
        }
    }

    public ICVSRemoteResource buildBaseTree(IResource resource, boolean immutable, IProgressMonitor monitor) throws TeamException {
        try {
            monitor.beginTask(null, -1);
            ICVSRemoteResource iCVSRemoteResource = ((CVSResourceVariantTree)this.getBaseTree()).buildTree(null, resource, immutable, monitor);
            return iCVSRemoteResource;
        }
        finally {
            monitor.done();
        }
    }

    public ICVSRemoteResource buildRemoteTree(IResource resource, boolean immutable, IProgressMonitor monitor) throws TeamException {
        try {
            monitor.beginTask(null, -1);
            ICVSRemoteResource iCVSRemoteResource = ((CVSResourceVariantTree)this.getRemoteTree()).buildTree(null, resource, immutable, monitor);
            return iCVSRemoteResource;
        }
        finally {
            monitor.done();
        }
    }

    public int getState(ResourceMapping mapping, int stateMask, IProgressMonitor monitor) throws CoreException {
        if ((stateMask & 0x200) == 0) {
            ResourceTraversal[] traversals = mapping.getTraversals((ResourceMappingContext)new SubscriberResourceMappingContext((Subscriber)this, false), monitor);
            if (this.hasLocalChanges(traversals, monitor)) {
                int state = 256;
                return state |= this.getOutgoingKind(traversals, monitor);
            }
            return 0;
        }
        return super.getState(mapping, stateMask, monitor);
    }

    private int getOutgoingKind(ResourceTraversal[] traversals, IProgressMonitor monitor) throws CoreException {
        int kind = 0;
        int i = 0;
        while (i < traversals.length) {
            ResourceTraversal traversal = traversals[i];
            IResource[] resources = traversal.getResources();
            int j = 0;
            while (j < resources.length) {
                IResource resource = resources[j];
                IDiff node = this.getDiff(resource);
                if (node == null) {
                    return 4;
                }
                int nextKind = node.getKind();
                if (kind == 0) {
                    kind = nextKind;
                }
                if (nextKind != kind || nextKind == 4) {
                    return 4;
                }
                ++j;
            }
            ++i;
        }
        return kind;
    }

    public boolean hasLocalChanges(ResourceTraversal[] traversals, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        int i = 0;
        while (i < traversals.length) {
            ResourceTraversal traversal = traversals[i];
            IResource[] resources = traversal.getResources();
            switch (traversal.getDepth()) {
                case 0: {
                    IResource resource;
                    int j = 0;
                    while (j < resources.length) {
                        resource = resources[j];
                        if (this.isDirectlyDirty(resource, monitor)) {
                            return true;
                        }
                        ++j;
                    }
                    break;
                }
                case 2: {
                    IResource resource;
                    int j = 0;
                    while (j < resources.length) {
                        resource = resources[j];
                        if (this.isDirty(resource, monitor)) {
                            return true;
                        }
                        ++j;
                    }
                    break;
                }
                case 1: {
                    IResource resource;
                    int j = 0;
                    while (j < resources.length) {
                        resource = resources[j];
                        if (this.isDirectlyDirty(resource, monitor)) {
                            return true;
                        }
                        IResource[] children = this.members(resource);
                        int k = 0;
                        while (k < children.length) {
                            IResource child = children[k];
                            if (this.isDirectlyDirty(child, monitor)) {
                                return true;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isDirectlyDirty(IResource resource, IProgressMonitor monitor) throws CoreException {
        IDiff node;
        return resource.getType() == 1 ? this.isDirty(resource, monitor) : (node = this.getDiff(resource)) != null && node instanceof IThreeWayDiff && ((IThreeWayDiff)node).getLocalChange() != null && ((IThreeWayDiff)node).getLocalChange().getKind() != 0;
    }

    public boolean isDirty(ICVSResource cvsResource, IProgressMonitor monitor) throws CVSException {
        if (cvsResource.exists()) {
            return !cvsResource.isIgnored() && cvsResource.isModified(monitor);
        }
        return cvsResource.isManaged() && cvsResource.isModified(monitor);
    }

    public boolean isDirty(IResource resource, IProgressMonitor monitor) throws CVSException {
        try {
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor(resource);
            return this.isDirty(cvsResource, monitor);
        }
        catch (CVSException e) {
            boolean accessible = resource.getProject().isAccessible();
            if (accessible) {
                throw e;
            }
            return accessible;
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == ActiveChangeSetManager.class) {
            return CVSProviderPlugin.getPlugin().getChangeSetManager();
        }
        return super.getAdapter(adapter);
    }

    public void refreshWithContentFetch(ResourceTraversal[] traversals, IProgressMonitor monitor) throws TeamException {
        try {
            this.contentFetch = true;
            this.refresh(traversals, monitor);
        }
        finally {
            this.contentFetch = false;
        }
    }

    @Override
    protected boolean getCacheFileContentsHint() {
        return this.contentFetch;
    }
}

