/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.diffmerge.bridge.util.structures.Tuple2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionsUtil {
    private CollectionsUtil() {
    }

    public static boolean areEqual(Object o1_p, Object o2_p) {
        return o1_p == null && o2_p == null || o1_p != null && o1_p.equals(o2_p);
    }

    public static <T> List<T> constantList(T ... elements_p) {
        return Collections.unmodifiableList(Arrays.asList(elements_p));
    }

    public static <K, V> Map<K, V> constantMap(Tuple2<? extends K, ? extends V> ... couples_p) {
        LinkedHashMap result = new LinkedHashMap();
        Tuple2<? extends K, ? extends V>[] tuple2Array = couples_p;
        int n = couples_p.length;
        int n2 = 0;
        while (n2 < n) {
            Tuple2<K, V> couple = tuple2Array[n2];
            if (couple == null) {
                throw new IllegalArgumentException("Null couple in constant map declaration");
            }
            V former = result.put(couple.get1(), couple.get2());
            if (former != null) {
                throw new IllegalArgumentException("Duplicate key in constant map declaration: " + couple.get1());
            }
            ++n2;
        }
        return Collections.unmodifiableMap(result);
    }

    public static <T> Set<T> constantSet(T ... elements_p) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(Arrays.asList(elements_p));
        result.remove(null);
        return Collections.unmodifiableSet(result);
    }

    public static <T> Iterator<T> emptyIterator() {
        return Collections.emptySet().iterator();
    }

    public static Collection<Object> flatten(Object object_p) {
        LinkedHashSet result = new LinkedHashSet();
        LinkedList<Object> toExplore = new LinkedList<Object>();
        HashSet explored = new HashSet();
        toExplore.add(object_p);
        while (!toExplore.isEmpty()) {
            Object current = toExplore.removeFirst();
            explored.add(current);
            if (current instanceof Iterable) {
                for (Object currentPart : (Iterable)current) {
                    if (explored.contains(currentPart)) continue;
                    toExplore.add(currentPart);
                }
                continue;
            }
            result.add(current);
        }
        return Collections.unmodifiableCollection(result);
    }

    public static <T> Collection<T> flattenFindAll(Object object_p, Class<T> type_p) {
        LinkedHashSet result = new LinkedHashSet();
        LinkedList<Object> toExplore = new LinkedList<Object>();
        HashSet explored = new HashSet();
        toExplore.add(object_p);
        boolean typeIsObject = type_p.equals(Object.class);
        while (!toExplore.isEmpty()) {
            Object current = toExplore.removeFirst();
            boolean isIterable = current instanceof Iterable;
            if (!(!type_p.isInstance(current) || typeIsObject && isIterable)) {
                Object elected = current;
                result.add(elected);
                isIterable = false;
            }
            explored.add(current);
            if (!isIterable) continue;
            for (Object currentPart : (Iterable)current) {
                if (explored.contains(currentPart)) continue;
                toExplore.add(currentPart);
            }
        }
        return result;
    }

    public static <T> T flattenFindOne(Object object_p, Class<T> type_p) {
        LinkedList<Object> toExplore = new LinkedList<Object>();
        HashSet explored = new HashSet();
        toExplore.add(object_p);
        boolean typeIsObject = type_p.equals(Object.class);
        while (!toExplore.isEmpty()) {
            Object current = toExplore.removeFirst();
            boolean isIterable = current instanceof Iterable;
            if (!(!type_p.isInstance(current) || typeIsObject && isIterable)) {
                Object result = current;
                return (T)result;
            }
            explored.add(current);
            if (!isIterable) continue;
            for (Object currentPart : (Iterable)current) {
                if (explored.contains(currentPart)) continue;
                toExplore.add(currentPart);
            }
        }
        return null;
    }

    public static <T> Iterator<T> singletonIterator(T object_p) {
        return Collections.singleton(object_p).iterator();
    }
}

