/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.variables.details;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.commands.IHandler;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValueModification;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.VariableValueEditorManager;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class DetailPaneAssignValueAction
extends Action {
    private IHandlerActivation fHandlerActivation;
    private IViewSite fViewSite;
    private ITextViewer fTextViewer;
    private IStructuredSelection fCurrentSelection;

    public static void assignValue(Shell shell, IVariable variable, String newValueExpression) {
        String modelIdentifier = variable.getModelIdentifier();
        IVariableValueEditor editor = VariableValueEditorManager.getDefault().getVariableValueEditor(modelIdentifier);
        if (editor != null && editor.saveVariable(variable, newValueExpression, shell)) {
            return;
        }
        try {
            if (variable.verifyValue(newValueExpression)) {
                variable.setValue(newValueExpression);
            } else if (shell != null) {
                DebugUIPlugin.errorDialog(shell, ActionMessages.DetailPaneAssignValueAction_2, MessageFormat.format((String)ActionMessages.DetailPaneAssignValueAction_3, (Object[])new Object[]{newValueExpression, variable.getName()}), new StatusInfo(4, ActionMessages.DetailPaneAssignValueAction_4));
            }
        }
        catch (DebugException e) {
            MessageDialog.openError((Shell)shell, (String)ActionMessages.DetailPaneAssignValueAction_0, (String)e.getStatus().getMessage());
        }
    }

    public DetailPaneAssignValueAction(ITextViewer textViewer, IViewSite viewSite) {
        super(ActionMessages.DetailPaneAssignValueAction_1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.detail_pane_assign_value_action_context");
        this.fTextViewer = textViewer;
        this.fViewSite = viewSite;
        this.setEnabled(false);
        IHandlerService service = (IHandlerService)this.fViewSite.getService(IHandlerService.class);
        ActionHandler handler = new ActionHandler((IAction)this);
        this.fHandlerActivation = service.activateHandler(this.getActionDefinitionId(), (IHandler)handler);
    }

    public void dispose() {
        IHandlerService service = (IHandlerService)this.fViewSite.getService(IHandlerService.class);
        service.deactivateHandler(this.fHandlerActivation);
    }

    public void updateCurrentVariable(IStructuredSelection selection) {
        IValueModification valMod;
        boolean enabled = false;
        if (selection.size() == 1 && selection.getFirstElement() instanceof IValueModification && (valMod = (IValueModification)selection.getFirstElement()).supportsValueModification()) {
            this.fCurrentSelection = selection;
            enabled = true;
        }
        this.setEnabled(enabled);
    }

    public void run() {
        IVariable variable = (IVariable)this.fCurrentSelection.getFirstElement();
        Point selection = this.fTextViewer.getSelectedRange();
        String value = null;
        if (selection.y == 0) {
            value = this.fTextViewer.getDocument().get();
        } else {
            try {
                value = this.fTextViewer.getDocument().get(selection.x, selection.y);
            }
            catch (BadLocationException badLocationException) {}
        }
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        Shell activeShell = null;
        if (window != null) {
            activeShell = window.getShell();
        }
        DetailPaneAssignValueAction.assignValue(activeShell, variable, value);
    }

    public String getActionDefinitionId() {
        return "org.eclipse.ui.file.save";
    }
}

