/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.generators.util;

import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractResource;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.EMFResource;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.FileSystemResource;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.util.VpdescSwitch;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint;

public class VpdescUsedResourceSwitch
extends VpdescSwitch<AbstractResource> {
    private static final String DIAGRAM_EXTENSION = "odesign";
    private Viewpoint target;

    public VpdescUsedResourceSwitch(Viewpoint target) {
        this.target = target;
    }

    public AbstractResource caseEMFResource(EMFResource er) {
        String uri = er.getUri();
        String decoratedURI = this.decorateStringWithQuotation(uri);
        if (this.checkExtensionService(uri, DIAGRAM_EXTENSION)) {
            if (!this.target.getUseDiagramResource().contains((Object)decoratedURI)) {
                this.target.getUseDiagramResource().add((Object)decoratedURI);
            }
        } else if (!this.target.getUseAnyEMFResource().contains((Object)decoratedURI)) {
            this.target.getUseAnyEMFResource().add((Object)decoratedURI);
        }
        return er;
    }

    public AbstractResource caseFilesystemResource(FileSystemResource fsr) {
        this.target.getUseAnyEMFResource().add((Object)this.decorateStringWithQuotation(fsr.getPath()));
        return fsr;
    }

    private boolean checkExtensionService(String s, String extension) {
        return s.endsWith(extension = "." + extension);
    }

    private String decorateStringWithQuotation(String s) {
        return "\"" + s + "\"";
    }
}

