/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoriesViewContentHandler
extends DefaultHandler {
    public static final String REPOSITORIES_VIEW_TAG = "repositories-view";
    public static final String REPOSITORY_TAG = "repository";
    public static final String WORKING_SET_TAG = "working-set";
    public static final String CURRENT_WORKING_SET_TAG = "current-working-set";
    public static final String MODULE_TAG = "module";
    public static final String TAG_TAG = "tag";
    public static final String AUTO_REFRESH_FILE_TAG = "auto-refresh-file";
    public static final String DATE_TAGS_TAG = "date-tags";
    public static final String DATE_TAG_TAG = "date-tag";
    public static final String ID_ATTRIBUTE = "id";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String PATH_ATTRIBUTE = "path";
    public static final String FULL_PATH_ATTRIBUTE = "full-path";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String READ_ID_ATTRIBUTE = "read-id";
    public static final String WRITE_ID_ATTRIBUTE = "write-id";
    public static final String LAST_ACCESS_TIME_ATTRIBUTE = "lastAcessTime";
    public static final String[] TAG_TYPES = new String[]{"head", "branch", "version", "date"};
    public static final String DEFAULT_TAG_TYPE = "version";
    public static final String DEFINED_MODULE_TYPE = "defined";
    private RepositoryManager manager;
    private StringBuffer buffer = new StringBuffer();
    private Stack tagStack = new Stack();
    private RepositoryRoot currentRepositoryRoot;
    private String currentRemotePath;
    private List tags;
    private List dateTags;
    private List autoRefreshFiles;
    private boolean ignoreElements;
    private long lastAccessTime;

    public RepositoriesViewContentHandler(RepositoryManager manager) {
        this.manager = manager;
    }

    @Override
    public void characters(char[] chars, int startIndex, int length) throws SAXException {
        this.buffer.append(chars, startIndex, length);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String elementName = this.getElementName(namespaceURI, localName, qName);
        if (!elementName.equals(this.tagStack.peek())) {
            throw new SAXException(NLS.bind((String)CVSUIMessages.RepositoriesViewContentHandler_unmatchedTag, (Object[])new String[]{elementName}));
        }
        if (!elementName.equals(REPOSITORIES_VIEW_TAG)) {
            if (elementName.equals(REPOSITORY_TAG)) {
                if (!this.ignoreElements) {
                    this.manager.add(this.currentRepositoryRoot);
                }
                this.currentRepositoryRoot = null;
            } else if (elementName.equals(WORKING_SET_TAG)) {
                this.ignoreElements = false;
            } else if (elementName.equals(CURRENT_WORKING_SET_TAG)) {
                this.ignoreElements = false;
            } else if (elementName.equals(MODULE_TAG)) {
                if (!this.ignoreElements && this.currentRepositoryRoot != null) {
                    this.currentRepositoryRoot.addTags(this.currentRemotePath, this.tags.toArray(new CVSTag[this.tags.size()]));
                    if (this.lastAccessTime > 0L) {
                        this.currentRepositoryRoot.setLastAccessedTime(this.currentRemotePath, this.lastAccessTime);
                    }
                    this.currentRepositoryRoot.setAutoRefreshFiles(this.currentRemotePath, this.autoRefreshFiles.toArray(new String[this.autoRefreshFiles.size()]));
                }
            } else if (elementName.equals(DATE_TAG_TAG) && !this.ignoreElements && this.currentRepositoryRoot != null) {
                for (CVSTag tag : this.dateTags) {
                    this.currentRepositoryRoot.addDateTag(tag);
                }
            }
        }
        this.tagStack.pop();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String elementName = this.getElementName(namespaceURI, localName, qName);
        if (!elementName.equals(REPOSITORIES_VIEW_TAG)) {
            if (elementName.equals(REPOSITORY_TAG)) {
                ICVSRepositoryLocation root;
                String id = atts.getValue(ID_ATTRIBUTE);
                if (id == null) {
                    throw new SAXException(NLS.bind((String)CVSUIMessages.RepositoriesViewContentHandler_missingAttribute, (Object[])new String[]{REPOSITORY_TAG, ID_ATTRIBUTE}));
                }
                try {
                    root = KnownRepositories.getInstance().getRepository(id);
                    if (!KnownRepositories.getInstance().isKnownRepository(id)) {
                        KnownRepositories.getInstance().addRepository(root, false);
                    }
                }
                catch (CVSException e) {
                    throw new SAXException(NLS.bind((String)CVSUIMessages.RepositoriesViewContentHandler_errorCreatingRoot, (Object[])new String[]{id}), (Exception)((Object)e));
                }
                this.currentRepositoryRoot = new RepositoryRoot(root);
                String name = atts.getValue(NAME_ATTRIBUTE);
                if (name != null) {
                    this.currentRepositoryRoot.setName(name);
                }
            } else if (elementName.equals(DATE_TAGS_TAG)) {
                this.dateTags = new ArrayList();
            } else if (elementName.equals(DATE_TAG_TAG)) {
                String name = atts.getValue(NAME_ATTRIBUTE);
                if (name == null) {
                    throw new SAXException(NLS.bind((String)CVSUIMessages.RepositoriesViewContentHandler_missingAttribute, (Object[])new String[]{DATE_TAGS_TAG, NAME_ATTRIBUTE}));
                }
                this.dateTags.add(new CVSTag(name, 3));
            } else if (elementName.equals(WORKING_SET_TAG)) {
                String name = atts.getValue(NAME_ATTRIBUTE);
                if (name == null) {
                    throw new SAXException(NLS.bind((String)CVSUIMessages.RepositoriesViewContentHandler_missingAttribute, (Object[])new String[]{WORKING_SET_TAG, NAME_ATTRIBUTE}));
                }
                this.ignoreElements = true;
            } else if (elementName.equals(MODULE_TAG)) {
                String path = atts.getValue(PATH_ATTRIBUTE);
                if (path == null) {
                    throw new SAXException(NLS.bind((String)CVSUIMessages.RepositoriesViewContentHandler_missingAttribute, (Object[])new String[]{MODULE_TAG, PATH_ATTRIBUTE}));
                }
                String type = atts.getValue(TYPE_ATTRIBUTE);
                if (type != null && type.equals(DEFINED_MODULE_TYPE)) {
                    path = RepositoryRoot.asDefinedModulePath(path);
                }
                long cachedTime = 0L;
                String cachedTimeString = atts.getValue(LAST_ACCESS_TIME_ATTRIBUTE);
                if (cachedTimeString != null) {
                    try {
                        Long time = Long.valueOf(cachedTimeString);
                        cachedTime = time;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                this.startModule(path, cachedTime);
            } else if (elementName.equals(TAG_TAG)) {
                String name;
                String type = atts.getValue(TYPE_ATTRIBUTE);
                if (type == null) {
                    type = DEFAULT_TAG_TYPE;
                }
                if ((name = atts.getValue(NAME_ATTRIBUTE)) == null) {
                    throw new SAXException(NLS.bind((String)CVSUIMessages.RepositoriesViewContentHandler_missingAttribute, (Object[])new String[]{TAG_TAG, NAME_ATTRIBUTE}));
                }
                this.tags.add(new CVSTag(name, this.getCVSTagType(type)));
            } else if (elementName.equals(AUTO_REFRESH_FILE_TAG)) {
                String path = atts.getValue(FULL_PATH_ATTRIBUTE);
                if (path == null) {
                    path = atts.getValue(PATH_ATTRIBUTE);
                    if (path == null) {
                        throw new SAXException(NLS.bind((String)CVSUIMessages.RepositoriesViewContentHandler_missingAttribute, (Object[])new String[]{AUTO_REFRESH_FILE_TAG, FULL_PATH_ATTRIBUTE}));
                    }
                    path = RepositoryRoot.isDefinedModuleName(this.currentRemotePath) ? null : new Path(null, this.currentRemotePath).append(path).toString();
                }
                if (path != null) {
                    this.autoRefreshFiles.add(path);
                }
            } else if (elementName.equals(CURRENT_WORKING_SET_TAG)) {
                this.ignoreElements = true;
            }
        }
        this.buffer = new StringBuffer();
        this.tagStack.push(elementName);
    }

    private void startModule(String path, long cachedTime) {
        this.currentRemotePath = path;
        this.tags = new ArrayList();
        this.lastAccessTime = cachedTime;
        this.autoRefreshFiles = new ArrayList();
    }

    public int getCVSTagType(String type) {
        int i = 0;
        while (i < TAG_TYPES.length) {
            if (TAG_TYPES[i].equals(type)) {
                return i;
            }
            ++i;
        }
        return 2;
    }

    private String getElementName(String namespaceURI, String localName, String qName) {
        if (localName != null && localName.length() > 0) {
            return localName;
        }
        return qName;
    }
}

