/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpbuild.Cron;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpbuild.GenerationLocation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpbuild.HudsonDeployment;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpbuild.SCM;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpbuild.SourceFolder;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpbuild.Trigger;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpbuild.User;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpbuild.UserPermission;

public class BuildVPConfigurationHelper {
    public static List<String> getSourceFolders(EList<SourceFolder> folders) {
        return BuildVPConfigurationHelper.getListOfFolders(folders);
    }

    private static List<String> getListOfFolders(EList<SourceFolder> folders) {
        ArrayList<String> sourceFolders = null;
        if (folders != null && !folders.isEmpty()) {
            sourceFolders = new ArrayList<String>();
            for (SourceFolder sourceFolder : folders) {
                sourceFolders.add(sourceFolder.getName());
            }
        }
        return sourceFolders;
    }

    public static Map<String, String> getUsers(EList<User> theusers) {
        return BuildVPConfigurationHelper.getMapOfUsers(theusers);
    }

    private static Map<String, String> getMapOfUsers(EList<User> theusers) {
        HashMap<String, String> users = null;
        if (theusers != null && !theusers.isEmpty()) {
            users = new HashMap<String, String>();
            for (User user : theusers) {
                if (user.getPermission() != null) {
                    users.put(user.getLogin(), user.getPermission().getName());
                    continue;
                }
                users.put(user.getLogin(), UserPermission.READ.getName());
            }
        }
        return users;
    }

    public static Map<String, String> getHudsonProperties(HudsonDeployment hudson) {
        return BuildVPConfigurationHelper.getMapOfHudsonProperties(hudson);
    }

    private static Map<String, String> getMapOfHudsonProperties(HudsonDeployment hudson) {
        HashMap<String, String> hudsonProperties = null;
        if (hudson != null) {
            hudsonProperties = new HashMap<String, String>();
            hudsonProperties.put(hudson.eClass().getEStructuralFeature(0).getName(), hudson.getAntName());
            hudsonProperties.put(hudson.eClass().getEStructuralFeature(1).getName(), hudson.getAssignedNode());
            hudsonProperties.put(hudson.eClass().getEStructuralFeature(2).getName(), hudson.getBuild_id());
            hudsonProperties.put(hudson.eClass().getEStructuralFeature(3).getName(), hudson.isEnabled() ? "true" : "false");
            hudsonProperties.put(hudson.eClass().getEStructuralFeature(4).getName(), hudson.getJdkName());
            hudsonProperties.put(hudson.eClass().getEStructuralFeature(5).getName(), hudson.getUserDeployJobName());
            hudsonProperties.put(hudson.eClass().getEStructuralFeature(7).getName(), hudson.getUserDeployServerUrl());
        }
        return hudsonProperties;
    }

    public static List<String> getCronTriggers(EList<Trigger> eList) {
        return BuildVPConfigurationHelper.getListOfTypeTriggers(eList, "CRON");
    }

    private static List<String> getListOfTypeTriggers(EList<Trigger> triggers, String type) {
        ArrayList<String> theTriggers = null;
        if (triggers != null && !triggers.isEmpty()) {
            if (type.equals("CRON")) {
                theTriggers = new ArrayList<String>();
                for (Trigger trigger : triggers) {
                    if (!(trigger instanceof Cron)) continue;
                    theTriggers.add(((Cron)trigger).getPlanning());
                }
                if (!theTriggers.isEmpty()) {
                    return theTriggers;
                }
            }
            if (type.equals("SCM")) {
                theTriggers = new ArrayList();
                for (Trigger trigger : triggers) {
                    if (!(trigger instanceof SCM)) continue;
                    theTriggers.add(((SCM)trigger).getPlanning());
                }
                if (!theTriggers.isEmpty()) {
                    return theTriggers;
                }
            }
        }
        return null;
    }

    public static List<String> getScmTriggers(EList<Trigger> triggers) {
        return BuildVPConfigurationHelper.getListOfTypeTriggers(triggers, "SCM");
    }

    public static Map<String, String> getGenerationLocation(GenerationLocation gl) {
        return BuildVPConfigurationHelper.getMapOfGenerationLocation(gl);
    }

    private static Map<String, String> getMapOfGenerationLocation(GenerationLocation gl) {
        HashMap<String, String> generationLocation = null;
        if (gl != null) {
            generationLocation = new HashMap<String, String>();
            generationLocation.put(gl.getFolder(), gl.getUrl());
        }
        return generationLocation;
    }
}

