/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.operation;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.internal.operation.ComparisonHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.AlphaDropShadowBorder;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public class RegionContainerUpdateLayoutOperation
extends AbstractModelChangeOperation<Void> {
    private final Node regionsContainer;
    private final boolean containsCreatedOrDeletedRegions;

    public RegionContainerUpdateLayoutOperation(Node regionsContainer) {
        super(Messages.RegionContainerUpdateLayoutOperation_name);
        this.regionsContainer = this.extractRealRegionsContainer(regionsContainer);
        this.containsCreatedOrDeletedRegions = false;
    }

    public RegionContainerUpdateLayoutOperation(Node regionsContainer, boolean containsCreatedOrDeletedRegions) {
        super(Messages.RegionContainerUpdateLayoutOperation_name);
        this.regionsContainer = this.extractRealRegionsContainer(regionsContainer);
        this.containsCreatedOrDeletedRegions = containsCreatedOrDeletedRegions;
    }

    private Node extractRealRegionsContainer(Node node) {
        int visualID;
        if (node != null && node.eContainer() instanceof Node && (7001 == (visualID = SiriusVisualIDRegistry.getVisualID((View)node)) || 7002 == visualID)) {
            return (Node)node.eContainer();
        }
        return node;
    }

    private List<Node> getRegionsToLayout() {
        ArrayList<Node> regionsToLayout = new ArrayList<Node>();
        if (this.regionsContainer != null) {
            Node labelNode = SiriusGMFHelper.getLabelNode((View)this.regionsContainer);
            ArrayList nodes = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.regionsContainer.getChildren(), Node.class));
            if (labelNode != null && nodes.size() == 2) {
                nodes.remove(labelNode);
                Node compartment = (Node)nodes.iterator().next();
                Iterables.addAll(regionsToLayout, (Iterable)Iterables.filter((Iterable)compartment.getChildren(), Node.class));
            }
        }
        return regionsToLayout;
    }

    @Override
    public Void execute() {
        EObject element;
        List<Node> regionsToLayout = this.getRegionsToLayout();
        if (!regionsToLayout.isEmpty() && (element = this.regionsContainer.getElement()) instanceof DNodeContainer) {
            DNodeContainer dnc = (DNodeContainer)element;
            ArrayList<Node> regionsToLayoutSortedByLocation = new ArrayList<Node>(regionsToLayout);
            RegionContainerUpdateLayoutOperation.sortRegionsAccordingToLocation(dnc, regionsToLayoutSortedByLocation);
            RegionContainerUpdateLayoutOperation.sortRegions(dnc, regionsToLayout);
            boolean isSameOrder = regionsToLayout.equals(regionsToLayoutSortedByLocation);
            if (!isSameOrder || this.containsCreatedOrDeletedRegions) {
                DNodeContainerExperimentalQuery query = new DNodeContainerExperimentalQuery(dnc);
                if (query.isVerticalStackContainer()) {
                    this.updateRegionsLayoutContraints(regionsToLayout, true, new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)dnc).isRegion());
                } else if (query.isHorizontaltackContainer()) {
                    this.updateRegionsLayoutContraints(regionsToLayout, false, new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)dnc).isRegion());
                }
            }
        }
        return null;
    }

    private void updateRegionsLayoutContraints(List<Node> regionsToLayout, boolean isVertical, boolean containerIsRegion) {
        Size regionContainerSize = null;
        LayoutConstraint regionContainerLayoutConstraint = this.regionsContainer.getLayoutConstraint();
        regionContainerSize = regionContainerLayoutConstraint instanceof Size ? (Size)regionContainerLayoutConstraint : NotationFactory.eINSTANCE.createSize();
        List<Dimension> defaultRegionsSizeAndOptionalLastRegionSize = null;
        Dimension regionsSizeComputedFromContainer = new Dimension(-1, -1);
        if (this.hasRegionContainerFixedSize(regionContainerSize, isVertical)) {
            defaultRegionsSizeAndOptionalLastRegionSize = this.computeRegionsSizeAccordingToContainerSize(regionsToLayout.size(), isVertical, containerIsRegion, regionContainerSize);
            regionsSizeComputedFromContainer = defaultRegionsSizeAndOptionalLastRegionSize.get(0);
        }
        HashMap<Node, Rectangle> regionsBounds = new HashMap<Node, Rectangle>();
        for (Node node : regionsToLayout) {
            Rectangle bounds = GMFHelper.getBounds(node, true, true);
            regionsBounds.put(node, bounds);
        }
        Dimension defaultRegionsSize = this.getDefaultRegionsSize(regionsBounds, regionsSizeComputedFromContainer);
        int y = 0;
        int x = 0;
        for (Node node : regionsToLayout) {
            Rectangle bounds = (Rectangle)regionsBounds.get(node);
            LayoutConstraint layoutConstraint = node.getLayoutConstraint();
            if (layoutConstraint instanceof Location) {
                Location loc = (Location)layoutConstraint;
                if (loc.getX() != x) {
                    loc.setX(x);
                }
                if (loc.getY() != y) {
                    loc.setY(y);
                }
            }
            if (layoutConstraint instanceof Size) {
                Size size = (Size)layoutConstraint;
                if (isVertical) {
                    if ((size.getWidth() != -1 || regionsSizeComputedFromContainer.width() != -1) && size.getWidth() != defaultRegionsSize.width()) {
                        size.setWidth(defaultRegionsSize.width());
                    }
                    if (regionsSizeComputedFromContainer.height() != -1) {
                        bounds.height = node.equals(regionsToLayout.get(regionsToLayout.size() - 1)) && defaultRegionsSizeAndOptionalLastRegionSize != null && defaultRegionsSizeAndOptionalLastRegionSize.size() == 2 ? defaultRegionsSizeAndOptionalLastRegionSize.get(1).height() : defaultRegionsSize.height();
                        size.setHeight(bounds.height);
                    }
                } else {
                    if ((size.getHeight() != -1 || regionsSizeComputedFromContainer.height() != -1) && size.getHeight() != defaultRegionsSize.height()) {
                        size.setHeight(defaultRegionsSize.height());
                    }
                    if (regionsSizeComputedFromContainer.width() != -1) {
                        bounds.width = node.equals(regionsToLayout.get(regionsToLayout.size() - 1)) && defaultRegionsSizeAndOptionalLastRegionSize != null && defaultRegionsSizeAndOptionalLastRegionSize.size() == 2 ? defaultRegionsSizeAndOptionalLastRegionSize.get(1).width() : defaultRegionsSize.width();
                        size.setWidth(bounds.width);
                    }
                }
            }
            if (isVertical) {
                y += bounds.height;
                continue;
            }
            x += bounds.width;
        }
        if (isVertical) {
            if (regionContainerSize.getHeight() != -1) {
                regionContainerSize.setHeight(-1);
            }
            if (regionContainerSize.getWidth() != -1) {
                regionContainerSize.setWidth(-1);
            }
        } else {
            if (regionContainerSize.getWidth() != -1) {
                regionContainerSize.setWidth(-1);
            }
            if (regionContainerSize.getHeight() != -1) {
                regionContainerSize.setHeight(-1);
            }
        }
    }

    private boolean hasRegionContainerFixedSize(Size regionsContainerSize, boolean isVertical) {
        EObject element;
        boolean result;
        boolean bl = result = regionsContainerSize.getWidth() != -1 && regionsContainerSize.getHeight() != -1;
        if (!result && (regionsContainerSize.getWidth() != -1 || regionsContainerSize.getHeight() != -1) && (element = this.regionsContainer.getElement()) instanceof DNodeContainer) {
            DNodeContainer dnc = (DNodeContainer)element;
            if (isVertical && regionsContainerSize.getHeight() != -1) {
                result = regionsContainerSize.getHeight() == dnc.getHeight().intValue();
            } else if (!isVertical && regionsContainerSize.getWidth() != -1) {
                result = regionsContainerSize.getWidth() == dnc.getWidth().intValue();
            }
        }
        return result;
    }

    private Dimension getDefaultRegionsSize(Map<Node, Rectangle> regionsBounds, Dimension regionSizeComputedFromContainer) {
        Dimension result = new Dimension(-1, -1);
        for (Rectangle bounds : regionsBounds.values()) {
            result.width = Math.max(result.width, bounds.width);
            result.height = Math.max(result.height, bounds.height);
        }
        if (regionSizeComputedFromContainer.width() != -1) {
            result.width = regionSizeComputedFromContainer.width();
        }
        if (regionSizeComputedFromContainer.height() != -1) {
            result.height = regionSizeComputedFromContainer.height();
        }
        return result;
    }

    private List<Dimension> computeRegionsSizeAccordingToContainerSize(int nbRegionsToLayout, boolean vertical, boolean containerIsRegion, Size regionsContainerSize) {
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        Dimension regionContainerContentPaneSize = new Dimension(regionsContainerSize.getWidth(), regionsContainerSize.getHeight());
        Dimension regionSize = new Dimension();
        int headerHeight = 0;
        Dimension labelDimension = GMFHelper.getLabelDimension(this.regionsContainer, new Dimension(20, 12));
        EObject element = this.regionsContainer.getElement();
        int borderSize = 0;
        boolean needShadowBorder = true;
        if (element instanceof DNodeContainer) {
            DNodeContainer dnc = (DNodeContainer)element;
            Style siriusStyle = dnc.getStyle();
            if (siriusStyle instanceof BorderedStyle && ((BorderedStyle)siriusStyle).getBorderSize() != null) {
                borderSize = ((BorderedStyle)siriusStyle).getBorderSize();
            }
            if (!new DDiagramElementQuery((DDiagramElement)dnc).isLabelHidden()) {
                int titleHeight = labelDimension.height();
                int separatorLineHeight = 1;
                int labelOffset = 5;
                if (!containerIsRegion) {
                    --labelOffset;
                }
                headerHeight = labelOffset + titleHeight + 5 + separatorLineHeight;
            }
            needShadowBorder = !new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)dnc).isRegion() && !(dnc.getOwnedStyle() instanceof WorkspaceImage);
        }
        regionContainerContentPaneSize.setHeight(regionContainerContentPaneSize.height() - (borderSize + headerHeight + borderSize));
        regionContainerContentPaneSize.setWidth(regionContainerContentPaneSize.width() - (borderSize + borderSize));
        if (needShadowBorder) {
            regionContainerContentPaneSize.setHeight(regionContainerContentPaneSize.height() - AlphaDropShadowBorder.getDefaultShadowSize());
            regionContainerContentPaneSize.setWidth(regionContainerContentPaneSize.width() - AlphaDropShadowBorder.getDefaultShadowSize());
        }
        if (vertical) {
            if (regionContainerContentPaneSize.height() != 0) {
                regionSize.setHeight(regionContainerContentPaneSize.height() / nbRegionsToLayout);
            }
            regionSize.setWidth(regionContainerContentPaneSize.width());
            result.add(regionSize);
            if (regionContainerContentPaneSize.height() % regionSize.height() != 0) {
                int lastRegionHeight = regionContainerContentPaneSize.height() - regionSize.height() * (nbRegionsToLayout - 1);
                result.add(new Dimension(regionContainerContentPaneSize.width(), lastRegionHeight));
            }
        } else {
            if (regionsContainerSize.getWidth() != 0) {
                regionSize.setWidth(regionContainerContentPaneSize.width() / nbRegionsToLayout);
            }
            regionSize.setHeight(regionContainerContentPaneSize.height());
            result.add(regionSize);
            if (regionContainerContentPaneSize.width() % regionSize.width() != 0) {
                int lastRegionWidth = regionContainerContentPaneSize.width() - regionSize.width() * (nbRegionsToLayout - 1);
                result.add(new Dimension(lastRegionWidth, regionContainerContentPaneSize.height()));
            }
        }
        return result;
    }

    public static void sortRegions(DNodeContainer dNodeContainer, List<? extends View> modelChildren) {
        new RegionComparisonHelper(dNodeContainer).sort(modelChildren);
    }

    public static void sortRegionsAccordingToLocation(DNodeContainer dNodeContainer, List<? extends View> modelChildren) {
        final DNodeContainerExperimentalQuery query = new DNodeContainerExperimentalQuery(dNodeContainer);
        Function<View, Integer> locationIndex = new Function<View, Integer>(){

            public Integer apply(View view) {
                LayoutConstraint constraint;
                if (view instanceof Node && (constraint = ((Node)view).getLayoutConstraint()) instanceof Location) {
                    if (query.isHorizontaltackContainer()) {
                        return ((Location)constraint).getX();
                    }
                    if (query.isVerticalStackContainer()) {
                        return ((Location)constraint).getY();
                    }
                }
                return Integer.MAX_VALUE;
            }
        };
        Collections.sort(modelChildren, Ordering.natural().onResultOf((Function)locationIndex));
    }

    private static class RegionComparisonHelper
    extends ComparisonHelper {
        private DNodeContainer self;

        public RegionComparisonHelper(DNodeContainer self) {
            this.self = self;
        }

        @Override
        protected List<? extends DRepresentationElement> getDElementsToSort() {
            return this.self.getOwnedDiagramElements();
        }

        @Override
        protected List<? extends RepresentationElementMapping> getMappingsToSort() {
            return this.self.getActualMapping().getAllContainerMappings();
        }
    }
}

