/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.views;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.actions.IMenuContributor;
import org.eclipse.ui.internal.cheatsheets.composite.explorer.RestartAllAction;
import org.eclipse.ui.internal.cheatsheets.composite.explorer.TreeExplorerMenu;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetSaveHelper;
import org.eclipse.ui.internal.cheatsheets.composite.model.EditableTask;
import org.eclipse.ui.internal.cheatsheets.composite.views.DescriptionPanel;
import org.eclipse.ui.internal.cheatsheets.composite.views.TaskEditorManager;
import org.eclipse.ui.internal.cheatsheets.composite.views.TaskExplorerManager;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.eclipse.ui.internal.cheatsheets.state.ICheatSheetStateManager;
import org.eclipse.ui.internal.cheatsheets.views.Page;
import org.eclipse.ui.internal.cheatsheets.views.ViewUtilities;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;
import org.eclipse.ui.internal.provisional.cheatsheets.TaskEditor;
import org.eclipse.ui.internal.provisional.cheatsheets.TaskExplorer;
import org.eclipse.ui.part.PageBook;

public class CompositeCheatSheetPage
extends Page
implements ISelectionChangedListener,
IMenuContributor {
    public static final String REVIEW_TAG = "__review__";
    public static final String END_REVIEW_TAG = "__endReview__";
    public static final String GOTO_TASK_TAG = "__goto__";
    public static final String START_HREF = "__start__";
    public static final String SKIP_HREF = "__skip__";
    private ManagedForm mform;
    private PageBook explorerContainer;
    private PageBook taskEditorContainer;
    private CompositeCheatSheetModel model;
    private TaskExplorer currentExplorer;
    private DescriptionPanel descriptionPanel;
    private CompositeCheatSheetSaveHelper saveHelper;
    private ICompositeCheatSheetTask selectedTask;
    private boolean initialized = false;
    private EndReviewListener endReviewListener;

    public CompositeCheatSheetPage(CompositeCheatSheetModel model, ICheatSheetStateManager stateManager) {
        this.model = model;
        this.saveHelper = new CompositeCheatSheetSaveHelper(stateManager);
    }

    @Override
    public void createPart(Composite parent) {
        this.init(parent.getDisplay());
        this.toolkit.getHyperlinkGroup().setHyperlinkUnderlineMode(2);
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setLayoutData((Object)new GridData(1808));
        FormColors colors = this.toolkit.getColors();
        this.toolkit.decorateFormHeading(this.form.getForm());
        this.mform = new ManagedForm(this.toolkit, this.form);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        this.form.getBody().setLayout((Layout)glayout);
        final SashForm sash = new SashForm(this.form.getBody(), 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 10;
        gd.heightHint = 10;
        sash.setLayoutData((Object)gd);
        sash.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = sash.getSize();
                if (size.x > size.y) {
                    sash.setOrientation(256);
                } else {
                    sash.setOrientation(512);
                }
                CompositeCheatSheetPage.this.updateSashPanelMargins(sash);
            }
        });
        sash.setBackground(colors.getColor("org.eclipse.ui.forms.TB_BG"));
        Composite explorerPanel = new Composite((Composite)sash, 0);
        explorerPanel.setBackground(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
        GridLayout playout = new GridLayout();
        playout.marginWidth = 0;
        playout.marginTop = 2;
        playout.marginBottom = 0;
        explorerPanel.setLayout((Layout)playout);
        this.toolkit.adapt(explorerPanel);
        this.explorerContainer = new PageBook(explorerPanel, 0);
        this.explorerContainer.setLayoutData((Object)new GridData(1808));
        Composite editorPanel = new Composite((Composite)sash, 0);
        playout = new GridLayout();
        playout.marginWidth = 0;
        playout.marginHeight = 0;
        editorPanel.setLayout((Layout)playout);
        editorPanel.setBackground(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
        this.taskEditorContainer = new PageBook(editorPanel, 0);
        this.toolkit.adapt((Composite)this.taskEditorContainer);
        this.taskEditorContainer.setLayoutData((Object)new GridData(1808));
    }

    private void updateSashPanelMargins(SashForm sash) {
        Control[] children = sash.getChildren();
        int orientation = sash.getOrientation();
        GridLayout layout = (GridLayout)((Composite)children[0]).getLayout();
        if (orientation == 256) {
            layout.marginBottom = 0;
            layout.marginRight = 1;
        } else {
            layout.marginBottom = 1;
            layout.marginRight = 0;
        }
        layout = (GridLayout)((Composite)children[1]).getLayout();
        if (orientation == 256) {
            layout.marginTop = 0;
            layout.marginLeft = 1;
        } else {
            layout.marginTop = 1;
            layout.marginLeft = 0;
        }
        ((Composite)children[0]).layout();
        ((Composite)children[1]).layout();
    }

    @Override
    public void dispose() {
        this.mform.dispose();
        super.dispose();
    }

    private void setInputModel(CompositeCheatSheetModel model, Map<String, String> layout) {
        this.model = model;
        this.mform.getForm().setText(ViewUtilities.escapeForLabel(model.getName()));
        String explorerId = model.getTaskExplorerId();
        this.setCurrentExplorerFromId(explorerId);
        String selectedTaskId = layout.get("selectedTask");
        AbstractTask selectedTask = null;
        if (selectedTaskId != null && (selectedTask = model.getDependencies().getTask(selectedTaskId)) != null) {
            this.currentExplorer.setSelection((ISelection)new StructuredSelection((Object)selectedTask), true);
        }
        if (selectedTask != null) {
            this.updateSelectedTask(selectedTask);
        } else {
            this.updateSelectedTask(model.getRootTask());
        }
        model.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ICompositeCheatSheetTask task = (ICompositeCheatSheetTask)arg;
                if (CompositeCheatSheetPage.this.currentExplorer != null) {
                    CompositeCheatSheetPage.this.currentExplorer.taskUpdated(task);
                }
                CompositeCheatSheetPage.this.updateTask(task);
            }
        });
    }

    private void setCurrentExplorerFromId(String explorerId) {
        TaskExplorer explorer = this.getTaskExplorer(explorerId);
        if (explorer != null) {
            explorer.setCompositeCheatSheet(this.model);
            explorer.setFocus();
            this.setExplorerVisible(explorerId);
        }
    }

    private void setExplorerVisible(String id) {
        Control[] excontrols = this.explorerContainer.getChildren();
        TaskExplorer explorer = null;
        int i = 0;
        while (i < excontrols.length) {
            Control excontrol = excontrols[i];
            explorer = (TaskExplorer)excontrol.getData("explorer");
            if (explorer.getId().equals(id)) {
                this.explorerContainer.showPage(excontrol);
                this.setCurrentExplorer(explorer);
                return;
            }
            ++i;
        }
    }

    private void setCurrentExplorer(TaskExplorer explorer) {
        if (this.currentExplorer != null) {
            this.currentExplorer.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.currentExplorer = explorer;
        this.currentExplorer.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.updateForSelection(this.currentExplorer.getSelectionProvider().getSelection());
    }

    private TaskExplorer getTaskExplorer(String id) {
        Control[] excontrols = this.explorerContainer.getChildren();
        TaskExplorer explorer = null;
        int i = 0;
        while (i < excontrols.length) {
            Control excontrol = excontrols[i];
            Object data = excontrol.getData("explorer");
            if (data instanceof TaskExplorer && (explorer = (TaskExplorer)data).getId().equals(id)) {
                return explorer;
            }
            ++i;
        }
        TaskExplorerManager explorerManager = TaskExplorerManager.getInstance();
        explorer = explorerManager.getExplorer(id);
        if (explorer != null) {
            explorer.createControl((Composite)this.explorerContainer, this.mform.getToolkit());
            explorer.getControl().setData("explorer", (Object)explorer);
            new TreeExplorerMenu(explorer);
        }
        return explorer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateForSelection(event.getSelection());
    }

    private void updateForSelection(ISelection selection) {
        Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
        if (selectedElement instanceof ICompositeCheatSheetTask) {
            this.updateSelectedTask((ICompositeCheatSheetTask)selectedElement);
        }
    }

    private void updateSelectedTask(ICompositeCheatSheetTask task) {
        this.selectedTask = task;
        this.updateTask(this.selectedTask);
    }

    private void updateTask(ICompositeCheatSheetTask task) {
        if (task == null || task != this.selectedTask) {
            return;
        }
        if (task instanceof EditableTask) {
            EditableTask editable = (EditableTask)task;
            if (editable.getState() == 1) {
                this.showEditor(editable);
                return;
            }
            if (editable.isUnderReview()) {
                if (editable.getState() == 3) {
                    this.showEditor(editable);
                } else {
                    this.endReview(editable);
                }
                return;
            }
        }
        this.showDescription(task);
    }

    public void saveState() {
        HashMap<String, String> layout = new HashMap<String, String>();
        if (this.selectedTask != null) {
            layout.put("selectedTask", this.selectedTask.getId());
        }
        this.saveHelper.saveCompositeState(this.model, layout);
    }

    private void showDescription(ICompositeCheatSheetTask task) {
        if (this.descriptionPanel == null) {
            this.createDescriptionPanel();
        }
        this.descriptionPanel.showDescription(task);
        this.setCurrentEditor(this.descriptionPanel.getControl());
    }

    private void createDescriptionPanel() {
        this.descriptionPanel = new DescriptionPanel(this.mform, (Composite)this.taskEditorContainer);
        this.descriptionPanel.addHyperlinkListener((IHyperlinkListener)new DescriptionLinkListener());
    }

    private void showEditor(EditableTask task) {
        TaskEditor editor;
        if (task == this.selectedTask && (editor = this.getTaskEditor(task)) != null) {
            if (!task.isEditorInitialized()) {
                task.setInput(this.model.getTaskMemento(task.getId()));
            }
            this.setCurrentEditor((Control)editor.getControl().getParent());
        }
    }

    private void addHyperlink(StringBuffer buf, String href, String imageRef, String message) {
        buf.append("<p><a href=\"");
        buf.append(href);
        buf.append("\">");
        buf.append("<img href=\"");
        buf.append(imageRef);
        buf.append("\"/> ");
        buf.append(message);
        buf.append("</a></p>");
    }

    private void reviewTask(EditableTask task) {
        TaskEditor taskEditor = this.getTaskEditor(task);
        Composite container = taskEditor.getControl().getParent();
        Composite separator = this.toolkit.createCompositeSeparator(container);
        GridData data = new GridData();
        data.heightHint = 1;
        data.horizontalAlignment = 4;
        separator.setLayoutData((Object)data);
        FormText text = this.toolkit.createFormText(container, false);
        text.setImage("review", CheatSheetPlugin.getPlugin().getImage("COMPOSITE_TASK_REVIEW"));
        text.addHyperlinkListener((IHyperlinkListener)this.getEndReviewListener());
        text.setLayoutData((Object)new GridData(768));
        StringBuffer buf = new StringBuffer();
        buf.append("<form>");
        this.addHyperlink(buf, END_REVIEW_TAG + task.getId(), "review", Messages.COMPOSITE_PAGE_END_REVIEW);
        buf.append("</form>");
        text.setText(buf.toString(), true, false);
        task.setUnderReview(true);
        container.layout(true);
        this.showEditor(task);
    }

    private void endReview(EditableTask task) {
        TaskEditor taskEditor = this.getTaskEditor(task);
        Control editorControl = taskEditor.getControl();
        Composite container = editorControl.getParent();
        Control[] children = container.getChildren();
        int i = children.length - 2;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        task.setUnderReview(false);
        this.showDescription(task);
        container.layout();
    }

    private void setCurrentEditor(Control c) {
        this.taskEditorContainer.showPage(c);
    }

    private EndReviewListener getEndReviewListener() {
        if (this.endReviewListener == null) {
            this.endReviewListener = new EndReviewListener();
        }
        return this.endReviewListener;
    }

    private TaskEditor getTaskEditor(EditableTask editable) {
        TaskEditor editor;
        if (editable.getEditor() == null && (editor = TaskEditorManager.getInstance().getEditor(editable.getKind())) != null) {
            Composite editorPanel = new Composite((Composite)this.taskEditorContainer, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            editorPanel.setLayout((Layout)layout);
            this.mform.getToolkit().adapt(editorPanel);
            editor.createControl(editorPanel, this.mform.getToolkit());
            editable.setEditor(editor);
            GridData gridData = new GridData(1808);
            editor.getControl().setLayoutData((Object)gridData);
        }
        return editable.getEditor();
    }

    @Override
    public Control getControl() {
        return this.form;
    }

    @Override
    protected String getTitle() {
        return this.model.getName();
    }

    @Override
    public void initialized() {
        this.model.setSaveHelper(this.saveHelper);
        HashMap<String, String> layout = new HashMap<String, String>();
        this.model.loadState(layout);
        this.setInputModel(this.model, layout);
        this.initialized = true;
    }

    @Override
    public int contributeToViewMenu(Menu menu, int index) {
        if (!this.initialized) {
            return index;
        }
        index = this.contributeExplorerMenuItem(menu, index);
        return this.contributeRestartMenuItem(menu, index);
    }

    private int contributeRestartMenuItem(Menu menu, int index) {
        MenuItem item = new MenuItem(menu, 8, index++);
        item.setText(Messages.RESTART_ALL_MENU);
        item.setImage(CheatSheetPlugin.getPlugin().getImage("COMPOSITE_RESTART_ALL"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CompositeCheatSheetPage.this.model != null && RestartAllAction.confirmRestart()) {
                    CompositeCheatSheetPage.this.restart(null);
                }
            }
        });
        return index;
    }

    private int contributeExplorerMenuItem(Menu menu, int index) {
        String[] explorerIds = CheatSheetRegistryReader.getInstance().getExplorerIds();
        if (explorerIds.length == 1) {
            return index;
        }
        MenuItem menuItem = new MenuItem(menu, 64, index++);
        menuItem.setText(Messages.EXPLORER_PULLDOWN_MENU);
        Menu subMenu = new Menu(menu);
        menuItem.setMenu(subMenu);
        int i = 0;
        while (i < explorerIds.length) {
            final String id = explorerIds[i];
            CheatSheetRegistryReader.TaskExplorerNode node = CheatSheetRegistryReader.getInstance().findTaskExplorer(id);
            boolean isCurrentExplorer = id.equals(this.currentExplorer.getId());
            int style = isCurrentExplorer ? 16 : 8;
            MenuItem item = new MenuItem(subMenu, style);
            item.setText(node.getName());
            item.setSelection(isCurrentExplorer);
            item.setImage(TaskExplorerManager.getInstance().getImage(id));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CompositeCheatSheetPage.this.setCurrentExplorerFromId(id);
                }
            });
            ++i;
        }
        return index;
    }

    public void restart(Map<String, String> cheatSheetData) {
        this.model.resetAllTasks(cheatSheetData);
        this.currentExplorer.setSelection((ISelection)new StructuredSelection((Object)this.model.getRootTask()), true);
    }

    private final class DescriptionLinkListener
    extends HyperlinkAdapter {
        private DescriptionLinkListener() {
        }

        public void linkActivated(HyperlinkEvent e) {
            AbstractTask task;
            Object data;
            String ref = (String)e.getHref();
            if (ref.equals(CompositeCheatSheetPage.START_HREF) && (data = CompositeCheatSheetPage.this.descriptionPanel.getControl().getData("task")) instanceof EditableTask) {
                task = (EditableTask)data;
                ((EditableTask)task).setStarted();
            }
            if (ref.equals(CompositeCheatSheetPage.SKIP_HREF) && (data = CompositeCheatSheetPage.this.descriptionPanel.getControl().getData("task")) instanceof AbstractTask) {
                task = (AbstractTask)data;
                task.setState(2);
            }
            if (ref.equals(CompositeCheatSheetPage.REVIEW_TAG) && (data = CompositeCheatSheetPage.this.descriptionPanel.getControl().getData("task")) instanceof EditableTask) {
                CompositeCheatSheetPage.this.reviewTask((EditableTask)data);
            }
            if (ref.startsWith(CompositeCheatSheetPage.GOTO_TASK_TAG)) {
                String next = ref.substring(CompositeCheatSheetPage.GOTO_TASK_TAG.length());
                AbstractTask nextTask = CompositeCheatSheetPage.this.model.getDependencies().getTask(next);
                CompositeCheatSheetPage.this.currentExplorer.setSelection((ISelection)new StructuredSelection((Object)nextTask), true);
            }
        }
    }

    private final class EndReviewListener
    extends HyperlinkAdapter {
        private EndReviewListener() {
        }

        public void linkActivated(HyperlinkEvent e) {
            String ref = (String)e.getHref();
            if (ref.startsWith(CompositeCheatSheetPage.END_REVIEW_TAG)) {
                String next = ref.substring(CompositeCheatSheetPage.END_REVIEW_TAG.length());
                AbstractTask task = CompositeCheatSheetPage.this.model.getDependencies().getTask(next);
                CompositeCheatSheetPage.this.endReview((EditableTask)task);
            }
        }
    }
}

