/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.emfvalidation.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.ConstraintFactory;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.osgi.framework.Bundle;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Rule;
import org.polarsys.kitalpha.ad.viewpoint.emfvalidation.rules.ValidationContext;
import org.polarsys.kitalpha.ad.viewpoint.integration.rules.ElementDescriptor;
import org.polarsys.kitalpha.ad.viewpoint.integration.rules.RuleProvider;
import org.polarsys.kitalpha.ad.viewpoint.ui.Activator;
import org.polarsys.kitalpha.ad.viewpoint.utils.ModelAccessor;

public class EmfValidationRuleProvider
implements RuleProvider {
    private static final String EXTENSION_POINT_ID = "org.eclipse.emf.validation.constraintProviders";
    public static final String ID = "EMF validation";

    public ElementDescriptor[] getAvailableImplementations() {
        HashSet<String> names = new HashSet<String>();
        HashSet<String> implementations = new HashSet<String>();
        ArrayList<ElementDescriptor> result = new ArrayList<ElementDescriptor>();
        ModelValidationService.getInstance().loadXmlConstraintDeclarations();
        Collection allDescriptors = ConstraintRegistry.getInstance().getAllDescriptors();
        for (IConstraintDescriptor desc : allDescriptors) {
            String name = desc.getName();
            String implementation = desc.getId();
            if (name == null || implementation == null) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, Activator.getSymbolicName(), "An emf constraint has null properties (name:" + name + " id:" + implementation + ")"));
                continue;
            }
            if (names.contains(name) || implementations.contains(implementation)) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, Activator.getSymbolicName(), "An emf constraint already exists with this name or id (name:" + name + " id:" + implementation + ")"));
                continue;
            }
            names.add(name);
            implementations.add(implementation);
            result.add(new ElementDescriptor(name, implementation, desc.getPluginId()));
        }
        return result.toArray(new ElementDescriptor[result.size()]);
    }

    public String getType() {
        return ID;
    }

    public boolean canExecute(Rule rule, ModelAccessor properties, Object[] selection) {
        if (!this.checkSelection(selection)) {
            return false;
        }
        BasicDiagnostic diagnostic = this.createDiagnostic(rule);
        IConstraintDescriptor descriptor = this.getConstraintDescriptor(rule);
        if (descriptor == null) {
            diagnostic.add((Diagnostic)new BasicDiagnostic(2, Activator.getSymbolicName(), 0, "Cannot find rule: " + rule.getImplementation(), null));
            Activator.getDefault().getLog().log(BasicDiagnostic.toIStatus((Diagnostic)diagnostic));
            return false;
        }
        return true;
    }

    protected boolean checkSelection(Object[] selection) {
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof IAdaptable) {
                obj = ((IAdaptable)obj).getAdapter(EObject.class);
            }
            if (!(obj instanceof EObject)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void execute(Rule rule, ModelAccessor properties, Object[] selection) {
        BasicDiagnostic diagnostic = this.createDiagnostic(rule);
        IConstraintDescriptor descriptor = this.getConstraintDescriptor(rule);
        if (descriptor == null) {
            diagnostic.add((Diagnostic)new BasicDiagnostic(2, Activator.getSymbolicName(), 0, "Cannot find rule: " + rule.getImplementation(), null));
        } else {
            IModelConstraint newConstraint = ConstraintFactory.getInstance().newConstraint(descriptor);
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object target = objectArray[n2];
                ValidationContext ctx3 = new ValidationContext();
                ctx3.setConstraint(newConstraint);
                if (target instanceof EObject) {
                    ctx3.setTarget((EObject)target);
                }
                IStatus validate = newConstraint.validate((IValidationContext)ctx3);
                diagnostic.add((Diagnostic)new BasicDiagnostic(validate.getSeverity(), validate.getPlugin(), validate.getCode(), validate.getMessage(), null));
                ++n2;
            }
        }
        Activator.getDefault().getLog().log(BasicDiagnostic.toIStatus((Diagnostic)diagnostic));
    }

    private BasicDiagnostic createDiagnostic(Rule rule) {
        String name = "Diagnostic of " + rule.getImplementation() + " element";
        return new BasicDiagnostic(Activator.getSymbolicName(), 0, name, null);
    }

    private IConstraintDescriptor getConstraintDescriptor(Rule rule) {
        ModelValidationService.getInstance().loadXmlConstraintDeclarations();
        ConstraintRegistry instance = ConstraintRegistry.getInstance();
        return instance.getDescriptor(rule.getImplementation());
    }

    public boolean hasProvider(Bundle bundle) {
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(bundle.getSymbolicName());
        if (model == null) {
            return false;
        }
        IPluginExtension[] iPluginExtensionArray = model.getExtensions().getExtensions();
        int n = iPluginExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            if (EXTENSION_POINT_ID.equals(extension.getPoint())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

