/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.resourceimpl;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.exception.ViewpointResourceException;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.exception.ViewpointResourceProviderException;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.internal.ViewpointCoreResourceLocator;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.resourceimpl.EcoreProviderImpl;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.resourceimpl.GenerationchainProviderImpl;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.resourceimpl.GenmodelProviderImpl;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.resourceimpl.ViewpointResourceProviderFactory;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.types.ResourceFileInformation;

public class ViewpointResourceProviderRegistry {
    private static final ViewpointResourceProviderRegistry instance_ = new ViewpointResourceProviderRegistry();
    private Viewpoint viewpoint_;
    private EcoreProviderImpl ecoreProvider_;
    private GenmodelProviderImpl genmodelProvider_;
    private GenerationchainProviderImpl genchainProvider_;

    private ViewpointResourceProviderRegistry() {
    }

    public static ViewpointResourceProviderRegistry getInstance() {
        return instance_;
    }

    public void unload() {
        this.viewpoint_ = null;
        this.ecoreProvider_ = null;
        this.genchainProvider_ = null;
        this.genmodelProvider_ = null;
    }

    public void setViewpoint(Viewpoint viewpoint) throws ViewpointResourceProviderException {
        boolean isViewpointCoreResourcesAvailable;
        if (viewpoint == null) {
            throw new ViewpointResourceProviderException(10);
        }
        this.viewpoint_ = viewpoint;
        boolean isECoreInitialized = this.initializeEcoreProviders();
        boolean isGenchainInitialized = this.initializeGenchainProviders();
        boolean isGenmodelInitialized = this.initializeGenmodelProviders();
        boolean bl = isViewpointCoreResourcesAvailable = isECoreInitialized && isGenmodelInitialized && isGenchainInitialized;
        if (!isViewpointCoreResourcesAvailable) {
            throw new ViewpointResourceProviderException(20);
        }
    }

    public void refresh() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (this.ecoreProvider_ == null) {
            this.initializeEcoreProviders();
        } else {
            this.ecoreProvider_.refresh();
        }
        if (this.genchainProvider_ == null) {
            this.initializeGenchainProviders();
        } else {
            this.genchainProvider_.refresh();
        }
        this.initializeGenmodelProviders();
    }

    public boolean initializeEcoreProviders() {
        try {
            ResourceFileInformation information = ViewpointCoreResourceLocator.getECoreFileInformation(this.viewpoint_);
            if (information != null) {
                EcoreProviderImpl provider = ViewpointResourceProviderFactory.getInstance().createEcoreProvider(information);
                if (provider != null) {
                    this.ecoreProvider_ = provider;
                    this.ecoreProvider_.setHandler(this);
                    return true;
                }
                return false;
            }
        }
        catch (ViewpointResourceException viewpointResourceException) {
            return false;
        }
        return false;
    }

    public boolean initializeGenmodelProviders() {
        try {
            ResourceFileInformation information = ViewpointCoreResourceLocator.getGenmodelFileInformation(this.viewpoint_);
            if (information != null) {
                GenmodelProviderImpl provider = ViewpointResourceProviderFactory.getInstance().createGenmodelProvider(information);
                if (provider != null) {
                    this.genmodelProvider_ = provider;
                    this.genmodelProvider_.setHandler(this);
                    return true;
                }
                return false;
            }
        }
        catch (ViewpointResourceException viewpointResourceException) {
            return false;
        }
        return false;
    }

    public boolean initializeGenchainProviders() {
        try {
            ResourceFileInformation information = ViewpointCoreResourceLocator.getGenchainFileInformation(this.viewpoint_);
            if (information != null) {
                GenerationchainProviderImpl provider = ViewpointResourceProviderFactory.getInstance().createGenchainProvider(information);
                if (provider != null) {
                    this.genchainProvider_ = provider;
                    this.genchainProvider_.setHandler(this);
                    return true;
                }
                return false;
            }
        }
        catch (ViewpointResourceException viewpointResourceException) {
            return false;
        }
        return false;
    }

    public boolean isECoreProviderInitialized() {
        return this.ecoreProvider_ != null;
    }

    public boolean isGenmodelProviderInitialized() {
        return this.genmodelProvider_ != null;
    }

    public boolean isGenchainProviderInitialized() {
        return this.genchainProvider_ != null;
    }

    public Viewpoint getViewpoint() {
        return this.viewpoint_;
    }

    public EcoreProviderImpl getEcoreProvider() {
        return this.ecoreProvider_;
    }

    public GenmodelProviderImpl getGenmodelProvider() {
        return this.genmodelProvider_;
    }

    public GenerationchainProviderImpl getGenchainProvider() {
        return this.genchainProvider_;
    }
}

