/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;

public class URLFieldEditor
extends StringButtonFieldEditor {
    public URLFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.setEmptyStringAllowed(false);
        this.setChangeButtonText(JFaceResources.getString((String)"openBrowse"));
        this.setErrorMessage(AntPreferencesMessages.URLFieldEditor_0);
    }

    protected boolean doCheckState() {
        String text = this.getTextControl().getText();
        if (text != null && text.length() > 0) {
            try {
                new URL(text);
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return true;
    }

    protected String changePressed() {
        File d;
        URL url = null;
        try {
            url = new URL(this.getTextControl().getText());
        }
        catch (MalformedURLException malformedURLException) {}
        File f = null;
        if (url != null && !(f = new File(url.getFile())).exists()) {
            f = null;
        }
        if ((d = this.getDirectory(f)) == null) {
            return null;
        }
        try {
            return d.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            AntUIPlugin.log("Internal error setting documentation location", e);
            return null;
        }
    }

    private File getDirectory(File startingDirectory) {
        String dir;
        DirectoryDialog fileDialog = new DirectoryDialog(this.getShell(), 4096);
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        }
        if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }
}

