/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.pdt.introspector.core.services;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.kitalpha.pdt.introspector.core.IntrospectionContext;
import org.polarsys.kitalpha.pdt.introspector.core.messages.Messages;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.EclipseModel;

public class PlatformServices {
    public static void savePlatformModel(EclipseModel eclipseModel, String modelPath, ResourceSet resSet, IntrospectionContext introContext) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String filename = "";
        String productName = null;
        ITargetPlatformService defaultPlatform = TargetPlatformService.getDefault();
        try {
            ITargetHandle workspaceTargetHandle = defaultPlatform.getWorkspaceTargetHandle();
            productName = workspaceTargetHandle.getTargetDefinition().getName();
        }
        catch (CoreException e1) {
            Status errorStatus = new Status(4, "org.polarsys.kitalpha.pdt.introspector.core", Messages.ErrorGenerationTargetHandler, (Throwable)e1);
            StatusManager.getManager().handle((IStatus)errorStatus);
        }
        if (productName != null) {
            productName = productName.replaceAll(" ", "_");
        }
        filename = introContext.isVisitPlatform() && !introContext.isVisitWorkspace() ? String.valueOf(productName) + "_" + sdf.format(date) : (introContext.isVisitWorkspace() && !introContext.isVisitPlatform() ? "Workspace_" + sdf.format(date) : String.valueOf(productName) + "_and_Worskpace_" + sdf.format(date));
        String modelFullPath = String.valueOf(modelPath) + "\\" + filename + ".platform";
        URI uri = URI.createFileURI((String)modelFullPath);
        Resource resource = resSet.createResource(uri);
        resource.getContents().add((Object)eclipseModel);
        try {
            resource.save(options);
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (IOException e) {
            Status errorStatus = new Status(4, "org.polarsys.kitalpha.pdt.introspector.core", Messages.bind((String)Messages.ErrorSavingResource, (Object)uri.toString()), (Throwable)e);
            StatusManager.getManager().handle((IStatus)errorStatus);
        }
        catch (CoreException e) {
            Status errorStatus = new Status(4, "org.polarsys.kitalpha.pdt.introspector.core", Messages.ErrorRefreshWorkspace, (Throwable)e);
            StatusManager.getManager().handle((IStatus)errorStatus);
        }
    }
}

