/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.wait;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jkube.kit.build.service.docker.wait.WaitChecker;

public class TcpPortChecker
implements WaitChecker {
    private static final int TCP_PING_TIMEOUT = 500;
    private final List<Integer> ports;
    private final List<InetSocketAddress> pending;

    public TcpPortChecker(String host, List<Integer> ports) {
        this.ports = ports;
        this.pending = new ArrayList<InetSocketAddress>();
        for (int port : ports) {
            this.pending.add(new InetSocketAddress(host, port));
        }
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    @Override
    public boolean check() {
        Iterator<InetSocketAddress> iter = this.pending.iterator();
        while (iter.hasNext()) {
            InetSocketAddress address = iter.next();
            try {
                Socket s = new Socket();
                Throwable throwable = null;
                try {
                    s.connect(address, 500);
                    iter.remove();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (s == null) continue;
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    s.close();
                }
            }
            catch (IOException iOException) {}
        }
        return this.pending.isEmpty();
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public String getLogLabel() {
        return "on tcp port '" + this.pending + "'";
    }
}

