/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.wait;

import java.util.concurrent.CountDownLatch;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogGetHandle;
import org.eclipse.jkube.kit.build.service.docker.wait.LogMatchCallback;
import org.eclipse.jkube.kit.build.service.docker.wait.LogWaitCheckerCallback;
import org.eclipse.jkube.kit.build.service.docker.wait.WaitChecker;
import org.eclipse.jkube.kit.common.KitLogger;

public class LogWaitChecker
implements WaitChecker,
LogWaitCheckerCallback {
    private final String containerId;
    private final String logPattern;
    private final KitLogger log;
    private final CountDownLatch latch;
    private final LogGetHandle logHandle;

    public LogWaitChecker(String logPattern, DockerAccess dockerAccess, String containerId, KitLogger log) {
        this.containerId = containerId;
        this.logPattern = logPattern;
        this.log = log;
        this.latch = new CountDownLatch(1);
        this.logHandle = dockerAccess.getLogAsync(containerId, new LogMatchCallback(log, this, logPattern));
    }

    @Override
    public void matched() {
        this.latch.countDown();
        this.log.info("Pattern '%s' matched for container %s", new Object[]{this.logPattern, this.containerId});
    }

    @Override
    public boolean check() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public void cleanUp() {
        if (this.logHandle != null) {
            this.logHandle.finish();
        }
    }

    @Override
    public String getLogLabel() {
        return "on log out '" + this.logPattern + "'";
    }
}

