/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.eclipse.jdt.ls.core.internal.managers.EclipseProjectImporter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class EclipseProjectImporterTest
extends AbstractProjectsManagerBasedTest {
    private static final String BAR_PATTERN = "**/bar";
    private EclipseProjectImporter importer;

    @Before
    public void setUp() {
        this.importer = new EclipseProjectImporter();
    }

    @Test
    public void importSimpleJavaProject() throws Exception {
        String name = "hello";
        this.importProjects("eclipse/" + name);
        IProject project = WorkspaceHelper.getProject(name);
        this.assertIsJavaProject(project);
        this.importProjects("eclipse/" + name);
        project = WorkspaceHelper.getProject(name);
        this.assertIsJavaProject(project);
    }

    @Test
    public void ignoreMissingResourceFilters() throws Exception {
        JavaClientConnection javaClient = new JavaClientConnection(this.client);
        try {
            String name = "ignored-filter";
            this.importProjects("eclipse/" + name);
            IProject project = WorkspaceHelper.getProject(name);
            this.assertIsJavaProject(project);
            this.assertNoErrors(project);
            Assert.assertEquals((long)1L, (long)this.logListener.getErrors().size());
            String error = this.logListener.getErrors().get(0);
            Assert.assertTrue((String)("Unexpected error: " + error), (boolean)error.startsWith("Missing resource filter type: 'org.eclipse.ui.ide.missingFilter'"));
            List loggedMessages = (List)this.clientRequests.get("logMessage");
            Assert.assertNull((String)("Unexpected logs " + loggedMessages), (Object)loggedMessages);
        }
        finally {
            javaClient.disconnect();
        }
    }

    @Test
    public void importMultipleJavaProject() throws Exception {
        List<IProject> projects = this.importProjects("eclipse/multi");
        Assert.assertEquals((long)3L, (long)projects.size());
        IProject bar = WorkspaceHelper.getProject("bar");
        this.assertIsJavaProject(bar);
        IProject foo = WorkspaceHelper.getProject("foo");
        this.assertIsJavaProject(foo);
    }

    @Test
    public void testJavaImportExclusions() throws Exception {
        List javaImportExclusions = JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getJavaImportExclusions();
        try {
            javaImportExclusions.add(BAR_PATTERN);
            List<IProject> projects = this.importProjects("eclipse/multi");
            Assert.assertEquals((long)2L, (long)projects.size());
            IProject bar = WorkspaceHelper.getProject("bar");
            Assert.assertNull((Object)bar);
            IProject foo = WorkspaceHelper.getProject("foo");
            this.assertIsJavaProject(foo);
        }
        finally {
            javaImportExclusions.remove(BAR_PATTERN);
        }
    }

    @Test
    public void testFindUniqueProject() throws Exception {
        String name = "project";
        IWorkspaceRoot root = (IWorkspaceRoot)Mockito.mock(IWorkspaceRoot.class);
        IWorkspace workspace = (IWorkspace)Mockito.mock(IWorkspace.class);
        Mockito.when((Object)workspace.getRoot()).thenReturn((Object)root);
        IProject p0 = this.mockProject(root, "project", false);
        IProject p = this.importer.findUniqueProject(workspace, name);
        Assert.assertSame((Object)p0, (Object)p);
        Mockito.when((Object)p0.exists()).thenReturn((Object)true);
        IProject p2 = this.mockProject(root, "project (2)", false);
        p = this.importer.findUniqueProject(workspace, name);
        Assert.assertSame((Object)p2, (Object)p);
        Mockito.when((Object)p0.exists()).thenReturn((Object)true);
        Mockito.when((Object)p2.exists()).thenReturn((Object)true);
        IProject p3 = this.mockProject(root, "project (3)", false);
        p = this.importer.findUniqueProject(workspace, name);
        Assert.assertSame((Object)p3, (Object)p);
    }

    private IProject mockProject(IWorkspaceRoot root, String name, boolean exists) {
        IProject p = (IProject)Mockito.mock(IProject.class);
        Mockito.when((Object)p.getName()).thenReturn((Object)name);
        Mockito.when((Object)p.exists()).thenReturn((Object)exists);
        Mockito.when((Object)p.toString()).thenReturn((Object)name);
        Mockito.when((Object)root.getProject(name)).thenReturn((Object)p);
        return p;
    }

    @After
    public void after() {
        this.importer = null;
    }
}

