/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.net.URI;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.handlers.ReferencesHandler;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.ReferenceContext;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ReferencesHandlerTest
extends AbstractProjectsManagerBasedTest {
    private ReferencesHandler handler;
    private IProject project;

    @Before
    public void setup() throws Exception {
        this.importProjects("eclipse/hello");
        this.project = WorkspaceHelper.getProject("hello");
        this.preferenceManager = (PreferenceManager)Mockito.mock(PreferenceManager.class);
        Mockito.when((Object)this.preferenceManager.getPreferences()).thenReturn((Object)new Preferences());
        this.handler = new ReferencesHandler(this.preferenceManager);
    }

    @Test
    public void testEmpty() {
        ReferenceParams param = new ReferenceParams();
        param.setPosition(new Position(1, 1));
        param.setContext(new ReferenceContext(false));
        param.setTextDocument(new TextDocumentIdentifier("/foo/bar"));
        List references = this.handler.findReferences(param, this.monitor);
        Assert.assertNotNull((Object)references);
        Assert.assertTrue((String)"references are not empty", (boolean)references.isEmpty());
    }

    @Test
    public void testReference() {
        URI uri = this.project.getFile("src/java/Foo2.java").getRawLocationURI();
        String fileURI = ResourceUtils.fixURI((URI)uri);
        ReferenceParams param = new ReferenceParams();
        param.setPosition(new Position(5, 16));
        param.setContext(new ReferenceContext(true));
        param.setTextDocument(new TextDocumentIdentifier(fileURI));
        List references = this.handler.findReferences(param, this.monitor);
        Assert.assertNotNull((String)"findReferences should not return null", (Object)references);
        Assert.assertEquals((long)1L, (long)references.size());
        Location l = (Location)references.get(0);
        String refereeUri = ResourceUtils.fixURI((URI)this.project.getFile("src/java/Foo3.java").getRawLocationURI());
        Assert.assertEquals((Object)refereeUri, (Object)l.getUri());
    }
}

