/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.junit.Assert;

public final class Lsp4jAssertions {
    private Lsp4jAssertions() {
    }

    public static void assertRange(int expectedLine, int expectedStart, int expectedEnd, Range range) {
        Assert.assertNotNull((String)"Range is null", (Object)range);
        Lsp4jAssertions.assertPosition(expectedLine, expectedStart, range.getStart());
        Lsp4jAssertions.assertPosition(expectedLine, expectedEnd, range.getEnd());
    }

    public static void assertPosition(int expectedLine, int expectedChar, Position position) {
        Assert.assertNotNull((String)"Position is null", (Object)position);
        Assert.assertEquals((String)("Unexpected line position from " + position), (long)expectedLine, (long)position.getLine());
        Assert.assertEquals((String)("Unexpected character position from " + position), (long)expectedChar, (long)position.getCharacter());
    }

    public static void assertTextEdit(int expectedLine, int expectedStart, int expectedEnd, String expectedText, TextEdit edit) {
        Assert.assertNotNull((String)"TextEdit is null", (Object)edit);
        Assert.assertEquals((Object)expectedText, (Object)edit.getNewText());
        Lsp4jAssertions.assertRange(expectedLine, expectedStart, expectedEnd, edit.getRange());
    }
}

