/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.preferences;

import java.util.StringTokenizer;

public class MemberSortOrder {
    public static final int TYPE_INDEX = 0;
    public static final int CONSTRUCTORS_INDEX = 1;
    public static final int METHOD_INDEX = 2;
    public static final int FIELDS_INDEX = 3;
    public static final int INIT_INDEX = 4;
    public static final int STATIC_FIELDS_INDEX = 5;
    public static final int STATIC_INIT_INDEX = 6;
    public static final int STATIC_METHODS_INDEX = 7;
    public static final int ENUM_CONSTANTS_INDEX = 8;
    public static final int N_CATEGORIES = 9;
    public static final String DEFAULT_ORDER = "T,SF,SI,SM,F,I,C,M";
    private final String fCategoryOffsetsSetting;
    private int[] fCategoryOffsets = null;

    public MemberSortOrder(String categoryByOffsetsSetting) {
        this.fCategoryOffsetsSetting = categoryByOffsetsSetting;
    }

    public int getCategoryIndex(int kind) {
        if (this.fCategoryOffsets == null) {
            this.fCategoryOffsets = this.getCategoryOffsets();
        }
        return this.fCategoryOffsets[kind];
    }

    private int[] getCategoryOffsets() {
        int[] offsets = new int[9];
        boolean success = this.fillCategoryOffsetsFromPreferenceString(this.fCategoryOffsetsSetting, offsets);
        if (!success) {
            this.fillCategoryOffsetsFromPreferenceString(DEFAULT_ORDER, offsets);
        }
        return offsets;
    }

    private boolean fillCategoryOffsetsFromPreferenceString(String str, int[] offsets) {
        if (str == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        int i = 0;
        offsets[8] = i++;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if ("T".equals(token)) {
                offsets[0] = i++;
                continue;
            }
            if ("M".equals(token)) {
                offsets[2] = i++;
                continue;
            }
            if ("F".equals(token)) {
                offsets[3] = i++;
                continue;
            }
            if ("I".equals(token)) {
                offsets[4] = i++;
                continue;
            }
            if ("SF".equals(token)) {
                offsets[5] = i++;
                continue;
            }
            if ("SI".equals(token)) {
                offsets[6] = i++;
                continue;
            }
            if ("SM".equals(token)) {
                offsets[7] = i++;
                continue;
            }
            if (!"C".equals(token)) continue;
            offsets[1] = i++;
        }
        return i == 9;
    }
}

