/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;

public class MavenBuildSupport
implements IBuildSupport {
    @Override
    public boolean applies(IProject project) {
        return ProjectUtils.isMavenProject(project);
    }

    @Override
    public void update(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!this.applies(project)) {
            return;
        }
        JavaLanguageServerPlugin.logInfo("Starting Maven update for " + project.getName());
        IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
        MavenUpdateRequest request = new MavenUpdateRequest(project, MavenPlugin.getMavenConfiguration().isOffline(), true);
        configurationManager.updateProjectConfiguration(request, monitor);
    }

    @Override
    public boolean isBuildFile(IResource resource) {
        return resource != null && resource.getProject() != null && resource.getType() == 1 && resource.getName().equals("pom.xml") && resource.getProject().equals((Object)resource.getParent());
    }
}

