/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.SignatureHelpRequestor;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class SignatureHelpHandler {
    private static final int SEARCH_BOUND = 2000;
    private PreferenceManager preferenceManager;

    public static SignatureHelpOptions createOptions() {
        return new SignatureHelpOptions(Arrays.asList("("));
    }

    public SignatureHelpHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public SignatureHelp signatureHelp(TextDocumentPositionParams position, IProgressMonitor monitor) {
        SignatureHelp help;
        block6: {
            help = new SignatureHelp();
            if (!this.preferenceManager.getPreferences(null).isSignatureHelpEnabled()) {
                return help;
            }
            try {
                ICompilationUnit unit = JDTUtils.resolveCompilationUnit(position.getTextDocument().getUri());
                int offset = JsonRpcHelpers.toOffset(unit.getBuffer(), position.getPosition().getLine(), position.getPosition().getCharacter());
                int[] contextInfomation = this.getContextInfomation(unit.getBuffer(), offset);
                if (contextInfomation[0] == -1) {
                    return help;
                }
                SignatureHelpRequestor collector = new SignatureHelpRequestor(unit, contextInfomation[0] + 1);
                if (offset <= -1 || monitor.isCanceled()) break block6;
                unit.codeComplete(contextInfomation[0] + 1, (CompletionRequestor)collector, monitor);
                help = collector.getSignatureHelp(monitor);
                if (help == null) break block6;
                int currentParameter = contextInfomation[1];
                List infos = help.getSignatures();
                int i = 0;
                while (i < infos.size()) {
                    if (((SignatureInformation)infos.get(i)).getParameters().size() >= currentParameter + 1) {
                        help.setActiveSignature(Integer.valueOf(i));
                        help.setActiveParameter(Integer.valueOf(currentParameter));
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException ex) {
                JavaLanguageServerPlugin.logException("Find signatureHelp failure ", ex);
            }
        }
        return help;
    }

    private int[] getContextInfomation(IBuffer buffer, int offset) {
        int[] result = new int[2];
        result[1] = -1;
        result[0] = -1;
        int depth = 1;
        int i = offset - 1;
        while (i >= 0 && offset - i < 2000) {
            char c = buffer.getChar(i);
            if (c == ')') {
                ++depth;
            }
            if (c == '(') {
                --depth;
            }
            if (c == ',' && depth == 1) {
                result[1] = result[1] + 1;
            }
            if (depth == 0) {
                result[0] = i;
                break;
            }
            --i;
        }
        if (result[0] + 1 != offset) {
            result[1] = result[1] + 1;
        }
        return result;
    }
}

