/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;

public class DiagnosticsHandler
implements IProblemRequestor {
    private final List<IProblem> problems = new ArrayList<IProblem>();
    private final String uri;
    private final JavaClientConnection connection;
    private boolean reportAllErrors = true;
    private boolean isDefaultProject;

    public DiagnosticsHandler(JavaClientConnection conn, ICompilationUnit cu) {
        this.uri = JDTUtils.toURI(cu);
        this.connection = conn;
        this.isDefaultProject = JDTUtils.isDefaultProject(cu);
        this.reportAllErrors = !this.isDefaultProject && JDTUtils.isOnClassPath(cu);
    }

    public void acceptProblem(IProblem problem) {
        if (this.reportAllErrors || this.isSyntaxLikeError(problem)) {
            this.problems.add(problem);
        }
    }

    public boolean isSyntaxLikeError(IProblem problem) {
        if ((problem.getID() & 0x40000000) != 0) {
            return true;
        }
        if (!this.isDefaultProject && problem.getID() == 536871240) {
            return false;
        }
        if ((problem.getID() & 0x1000000) != 0 || (problem.getID() & 0x10000000) != 0) {
            return false;
        }
        switch (problem.getID()) {
            case 16777327: 
            case 33554502: 
            case 33554515: 
            case 0x4000064: 
            case 0x4000066: 
            case 67108984: 
            case 67109135: 
            case 67109264: 
            case 67109498: 
            case 0x8000081: 
            case 0x8000082: 
            case 0x22000032: 
            case 603979903: {
                return false;
            }
        }
        String error = this.getError(problem);
        JavaLanguageServerPlugin.logInfo(String.valueOf(problem.getMessage()) + " is of type " + error);
        return true;
    }

    private String getError(IProblem problem) {
        try {
            Field[] fieldArray = IProblem.class.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (Integer.TYPE.equals(field.getType()) && Integer.valueOf(problem.getID()).equals(field.get(null))) {
                    return field.getName();
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown";
    }

    public void beginReporting() {
        JavaLanguageServerPlugin.logInfo("begin problem for " + this.uri.substring(this.uri.lastIndexOf(47)));
        this.problems.clear();
    }

    public void endReporting() {
        JavaLanguageServerPlugin.logInfo(String.valueOf(this.problems.size()) + " problems reported for " + this.uri.substring(this.uri.lastIndexOf(47)));
        PublishDiagnosticsParams $ = new PublishDiagnosticsParams(ResourceUtils.toClientUri(this.uri), DiagnosticsHandler.toDiagnosticsArray(this.problems));
        this.connection.publishDiagnostics($);
    }

    public boolean isActive() {
        return true;
    }

    public static List<Diagnostic> toDiagnosticsArray(List<IProblem> problems) {
        ArrayList<Diagnostic> array = new ArrayList<Diagnostic>(problems.size());
        for (IProblem problem : problems) {
            Diagnostic diag = new Diagnostic();
            diag.setSource("Java");
            diag.setMessage(problem.getMessage());
            diag.setCode(Integer.toString(problem.getID()));
            diag.setSeverity(DiagnosticsHandler.convertSeverity(problem));
            diag.setRange(DiagnosticsHandler.convertRange(problem));
            array.add(diag);
        }
        return array;
    }

    private static DiagnosticSeverity convertSeverity(IProblem problem) {
        if (problem.isError()) {
            return DiagnosticSeverity.Error;
        }
        if (problem.isWarning()) {
            return DiagnosticSeverity.Warning;
        }
        return DiagnosticSeverity.Information;
    }

    private static Range convertRange(IProblem problem) {
        Position start = new Position();
        Position end = new Position();
        start.setLine(problem.getSourceLineNumber() - 1);
        end.setLine(problem.getSourceLineNumber() - 1);
        if (problem instanceof DefaultProblem) {
            DefaultProblem dProblem = (DefaultProblem)problem;
            start.setCharacter(dProblem.getSourceColumnNumber() - 1);
            int offset = 0;
            if (dProblem.getSourceStart() != -1 && dProblem.getSourceEnd() != -1) {
                offset = dProblem.getSourceEnd() - dProblem.getSourceStart() + 1;
            }
            end.setCharacter(dProblem.getSourceColumnNumber() - 1 + offset);
        }
        return new Range(start, end);
    }

    public void clearDiagnostics() {
        JavaLanguageServerPlugin.logInfo("Clearing problems for " + this.uri.substring(this.uri.lastIndexOf(47)));
        this.problems.clear();
        PublishDiagnosticsParams $ = new PublishDiagnosticsParams(ResourceUtils.toClientUri(this.uri), Collections.emptyList());
        this.connection.publishDiagnostics($);
    }

    public List<IProblem> getProblems() {
        return this.problems;
    }
}

