/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ChangeCorrectionProposal {
    private Change fChange;
    private String fName;
    private int fRelevance;

    public ChangeCorrectionProposal(String name, Change change, int relevance) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.fName = name;
        this.fChange = change;
        this.fRelevance = relevance;
    }

    public void apply() throws CoreException {
        this.performChange();
    }

    protected void performChange() throws CoreException {
        block9: {
            Change change = null;
            try {
                Change undoChange;
                change = this.getChange();
                if (change == null) break block9;
                change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                RefactoringStatus valid = change.isValid((IProgressMonitor)new NullProgressMonitor());
                if (valid.hasFatalError()) {
                    Status status = new Status(4, "org.eclipse.jdt.ls.core", 4, valid.getMessageMatchingSeverity(4), null);
                    throw new CoreException((IStatus)status);
                }
                IUndoManager manager = RefactoringCore.getUndoManager();
                boolean successful = false;
                try {
                    manager.aboutToPerformChange(change);
                    undoChange = change.perform((IProgressMonitor)new NullProgressMonitor());
                    successful = true;
                }
                finally {
                    manager.changePerformed(change, successful);
                }
                if (undoChange != null) {
                    undoChange.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                    manager.addUndo(this.getName(), undoChange);
                }
            }
            finally {
                if (change != null) {
                    change.dispose();
                }
            }
        }
    }

    public String getAdditionalProposalInfo(IProgressMonitor monitor) throws CoreException {
        StringBuffer buf;
        block3: {
            String name;
            block4: {
                buf = new StringBuffer();
                buf.append("<p>");
                Change change = this.getChange();
                if (change == null) break block3;
                name = change.getName();
                if (name.length() != 0) break block4;
                return null;
            }
            try {
                buf.append(name);
            }
            catch (CoreException e) {
                buf.append("Unexpected error when accessing this proposal:<p><pre>");
                buf.append(e.getLocalizedMessage());
                buf.append("</pre>");
            }
        }
        return null;
        buf.append("</p>");
        return buf.toString();
    }

    public String getName() {
        return this.fName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Change getChange() throws CoreException {
        ChangeCorrectionProposal changeCorrectionProposal = this;
        synchronized (changeCorrectionProposal) {
            if (this.fChange == null) {
                this.fChange = this.createChange();
            }
        }
        return this.fChange;
    }

    protected Change createChange() throws CoreException {
        return new NullChange();
    }

    public void setDisplayName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.fName = name;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }
}

