/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.rename;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.TextEditConverter;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.RippleMethodFinder;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenameProcessor {
    protected IJavaElement fElement;
    private IJavaProject fProjectCache;
    private IScanner fScannerCache;

    public RenameProcessor(IJavaElement selectedElement) {
        this.fElement = selectedElement;
    }

    public void renameOccurrences(final WorkspaceEdit edit, final String newName, IProgressMonitor monitor) throws CoreException {
        if (this.fElement == null || !this.canRename()) {
            return;
        }
        Object[] elementsToSearch = null;
        elementsToSearch = this.fElement instanceof IMethod ? RippleMethodFinder.getRelatedMethods((IMethod)this.fElement, monitor, null) : new IJavaElement[]{this.fElement};
        SearchPattern pattern = this.createOccurrenceSearchPattern((IJavaElement[])elementsToSearch);
        if (pattern == null) {
            return;
        }
        SearchEngine engine = new SearchEngine();
        engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.createSearchScope(), new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object o = match.getElement();
                if (o instanceof IJavaElement) {
                    IJavaElement element = (IJavaElement)o;
                    ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
                    if (compilationUnit == null) {
                        return;
                    }
                    TextEdit replaceEdit = RenameProcessor.this.collectMatch(match, element, compilationUnit, newName);
                    if (replaceEdit != null) {
                        RenameProcessor.this.convert(edit, compilationUnit, replaceEdit);
                    }
                }
            }
        }, monitor);
    }

    /*
     * Unable to fully structure code
     */
    protected SearchPattern createOccurrenceSearchPattern(IJavaElement[] elements) throws CoreException {
        if (elements == null || elements.length == 0) {
            return null;
        }
        set = new HashSet<IJavaElement>(Arrays.asList(elements));
        iter = set.iterator();
        first = (IJavaElement)iter.next();
        pattern = SearchPattern.createPattern((IJavaElement)first, (int)3);
        if (pattern != null) ** GOTO lbl14
        throw new CoreException(Status.CANCEL_STATUS);
lbl-1000:
        // 1 sources

        {
            each = (IJavaElement)iter.next();
            nextPattern = SearchPattern.createPattern((IJavaElement)each, (int)3);
            if (nextPattern == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            pattern = SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)nextPattern);
lbl14:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl15:
        // 1 sources

        return pattern;
    }

    protected void convert(WorkspaceEdit root, ICompilationUnit unit, TextEdit edits) {
        TextEditConverter converter = new TextEditConverter(unit, edits);
        String uri = JDTUtils.toURI(unit);
        Map changes = root.getChanges();
        if (changes.containsKey(uri)) {
            ((List)changes.get(uri)).addAll(converter.convert());
        } else {
            changes.put(uri, converter.convert());
        }
    }

    protected IJavaSearchScope createSearchScope() throws JavaModelException {
        return SearchEngine.createWorkspaceScope();
    }

    protected boolean canRename() throws CoreException {
        if (this.fElement instanceof IPackageFragment) {
            return false;
        }
        ICompilationUnit compilationUnit = (ICompilationUnit)this.fElement.getAncestor(5);
        return compilationUnit != null;
    }

    private TextEdit collectMatch(SearchMatch match, IJavaElement element, ICompilationUnit unit, String newName) throws IndexOutOfBoundsException, JavaModelException {
        if (match instanceof MethodReferenceMatch && ((MethodReferenceMatch)match).isSuperInvocation() && match.getAccuracy() == 1) {
            return null;
        }
        if (!(element instanceof IMethod) || match.isImplicit()) {
            return new ReplaceEdit(match.getOffset(), match.getLength(), newName);
        }
        int start = match.getOffset();
        int length = match.getLength();
        String matchText = unit.getBuffer().getText(start, length);
        if (newName.equals(matchText)) {
            return new ReplaceEdit(match.getOffset(), match.getLength(), newName);
        }
        if (match instanceof MethodDeclarationMatch && match.getElement() instanceof IMethod && ((IMethod)match.getElement()).isLambdaMethod()) {
            return null;
        }
        IScanner scanner = this.getScanner(unit);
        scanner.setSource(matchText.toCharArray());
        int simpleNameStart = -1;
        int simpleNameEnd = -1;
        try {
            int token = scanner.getNextToken();
            while (token != 158 && token != 7) {
                if (token == 5) {
                    simpleNameStart = scanner.getCurrentTokenStartPosition();
                    simpleNameEnd = scanner.getCurrentTokenEndPosition();
                }
                token = scanner.getNextToken();
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        if (simpleNameStart != -1) {
            match.setOffset(start + simpleNameStart);
            match.setLength(simpleNameEnd + 1 - simpleNameStart);
        }
        return new ReplaceEdit(match.getOffset(), match.getLength(), newName);
    }

    protected IScanner getScanner(ICompilationUnit unit) {
        IJavaProject project = unit.getJavaProject();
        if (project.equals(this.fProjectCache)) {
            return this.fScannerCache;
        }
        this.fProjectCache = project;
        String sourceLevel = project.getOption("org.eclipse.jdt.core.compiler.source", true);
        String complianceLevel = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        this.fScannerCache = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)sourceLevel, (String)complianceLevel);
        return this.fScannerCache;
    }
}

