/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.dataset.BroadcastIteratorBase;
import org.eclipse.january.dataset.BroadcastSingleIterator;
import org.eclipse.january.dataset.BroadcastUtils;
import org.eclipse.january.dataset.ContiguousSingleIterator;
import org.eclipse.january.dataset.ContiguousSingleIteratorElemental;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.InterfaceUtils;

public abstract class BroadcastSelfIterator
extends BroadcastIteratorBase {
    public static BroadcastSelfIterator createIterator(Dataset a, Dataset b) {
        if (Arrays.equals(a.getShapeRef(), b.getShapeRef()) && a.getStrides() == null && b.getStrides() == null) {
            return a.getElementsPerItem() == 1 && b.getElementsPerItem() == 1 ? new ContiguousSingleIteratorElemental(a, b) : new ContiguousSingleIterator(a, b);
        }
        return new BroadcastSingleIterator(a, b);
    }

    protected BroadcastSelfIterator(Dataset a, Dataset b) {
        super(a, b);
        this.read = InterfaceUtils.isNumerical(b.getClass());
        this.asDouble = this.aDataset.hasFloatingPointElements();
        BroadcastUtils.checkItemSize(a, b, null);
    }

    @Override
    protected void storeCurrentValues() {
        if (this.bIndex >= 0) {
            if (this.asDouble) {
                this.bDouble = this.bDataset.getElementDoubleAbs(this.bIndex);
            } else {
                this.bLong = this.bDataset.getElementLongAbs(this.bIndex);
            }
        }
    }
}

